/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history.filter;

import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.core.utility.StringMatcher;
import org.eclipse.team.svn.ui.history.filter.ILogEntryFilter;

public class ChangeNameLogEntryFilter
implements ILogEntryFilter {
    protected String changedPathToAccept;

    public ChangeNameLogEntryFilter() {
        this(null);
    }

    public ChangeNameLogEntryFilter(String changedPathToAccept) {
        this.changedPathToAccept = changedPathToAccept;
    }

    @Override
    public boolean accept(SVNLogEntry logEntry) {
        SVNLogPath[] paths;
        if (this.changedPathToAccept == null) {
            return true;
        }
        StringMatcher matcher = new StringMatcher(this.changedPathToAccept);
        SVNLogPath[] sVNLogPathArray = paths = logEntry.changedPaths == null ? new SVNLogPath[]{} : logEntry.changedPaths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            SVNLogPath path = sVNLogPathArray[n2];
            if (matcher.match(path.path)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setGangedPathToAccept(String changedPathToAccept) {
        this.changedPathToAccept = changedPathToAccept;
    }

    public String getGangedPathToAccept() {
        return this.changedPathToAccept;
    }
}

