/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.SSHSettings;
import org.eclipse.team.svn.core.resource.SSLSettings;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.internal.ui.TabFolderLayout;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.AbstractDynamicComposite;
import org.eclipse.team.svn.ui.composite.IPropertiesPanel;
import org.eclipse.team.svn.ui.composite.ISecurityInfoProvider;
import org.eclipse.team.svn.ui.composite.RepositoryPropertiesComposite;
import org.eclipse.team.svn.ui.composite.RepositoryRootsComposite;
import org.eclipse.team.svn.ui.composite.SSHComposite;
import org.eclipse.team.svn.ui.composite.SSLComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UserInputHistory;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.IValidationManager;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class RepositoryPropertiesTabFolder
extends Composite
implements IPropertiesPanel,
ISecurityInfoProvider {
    protected static final String AUTHOR_HISTORY_NAME = "authorName";
    protected RepositoryPropertiesComposite repositoryPropertiesPanel;
    protected SSHComposite sshComposite;
    protected SSLComposite sslComposite;
    protected RepositoryRootsComposite rootsComposite;
    protected Composite parent;
    protected IRepositoryLocation repositoryLocation;
    protected int style;
    protected IValidationManager validationManager;
    protected Button validateButton;
    protected Button resetChangesButton;
    protected boolean validateOnFinish;
    protected boolean forceDisableRoots;
    protected boolean createNew;
    protected Combo cachedRealms;
    protected boolean isAuthorNameEnabled;
    protected Combo authorInput;
    protected Button authorEnabled;
    protected UserInputHistory authorNameHistory;
    protected TabItem sshTab;
    protected TabItem sslTab;
    protected Composite unavailableSSHComposite;
    protected Composite unavailableProxyComposite;
    protected IRepositoryLocation backup;
    protected String sipUsername;
    protected String sipPassword;
    protected boolean sipIsPasswordSaved;
    protected SSHSettings sipSSHSettings;
    protected SSLSettings sipSSLSettings;

    public RepositoryPropertiesTabFolder(Composite parent, int style, IValidationManager validationManager, IRepositoryLocation repositoryLocation) {
        super(parent, style);
        this.parent = parent;
        this.style = style;
        this.validationManager = validationManager;
        this.repositoryLocation = repositoryLocation;
        boolean bl = this.createNew = repositoryLocation == null;
        if (this.createNew) {
            this.repositoryLocation = SVNRemoteStorage.instance().newRepositoryLocation();
        } else {
            this.backup = SVNRemoteStorage.instance().newRepositoryLocation();
            SVNRemoteStorage.instance().copyRepositoryLocation(this.backup, this.repositoryLocation);
        }
    }

    @Override
    public String getUsername() {
        this.sipUsername = this.repositoryPropertiesPanel.getUsernameDirect();
        return this.sipUsername;
    }

    @Override
    public void setUsername(String username) {
        this.sipUsername = username;
    }

    @Override
    public String getPassword() {
        this.sipPassword = this.repositoryPropertiesPanel.getPasswordDirect();
        return this.sipPassword;
    }

    @Override
    public void setPassword(String password) {
        this.sipPassword = password;
    }

    @Override
    public boolean isPasswordSaved() {
        this.sipIsPasswordSaved = this.repositoryPropertiesPanel.getPasswordSavedDirect();
        return this.sipIsPasswordSaved;
    }

    @Override
    public void setPasswordSaved(boolean saved) {
        this.sipIsPasswordSaved = saved;
    }

    @Override
    public SSLSettings getSSLSettings() {
        this.sipSSLSettings = this.sslComposite.getSSLSettingsDirect();
        return this.sipSSLSettings;
    }

    @Override
    public SSHSettings getSSHSettings() {
        this.sipSSHSettings = this.sshComposite.getSSHSettingsDirect();
        return this.sipSSHSettings;
    }

    @Override
    public void commit() {
        this.repositoryPropertiesPanel.setUsernameDirect(this.sipUsername);
        this.repositoryPropertiesPanel.setPasswordDirect(this.sipPassword);
        this.repositoryPropertiesPanel.setPasswordSavedDirect(this.sipIsPasswordSaved);
        this.sshComposite.setSSHSettingsDirect(this.sipSSHSettings);
        this.sslComposite.setSSLSettingsDirect(this.sipSSLSettings);
    }

    @Override
    public void initialize() {
        int widthHint;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 7;
        this.setLayout((Layout)layout);
        TabFolder tabFolder = new TabFolder((Composite)this, 0);
        tabFolder.setLayout((Layout)new TabFolderLayout());
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNUIMessages.RepositoryPropertiesTabFolder_General);
        tabItem.setControl((Control)this.createRepositoryPropertiesPanel((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(SVNUIMessages.RepositoryPropertiesTabFolder_Advanced);
        Composite rootsComposite = this.createRepositoryRootsComposite((Composite)tabFolder);
        GridData data = new GridData();
        data.verticalIndent = 10;
        this.authorEnabled = new Button(rootsComposite, 32);
        this.authorEnabled.setText(SVNUIMessages.NewRepositoryLocationWizard_OverrideAuthor);
        this.authorEnabled.setSelection(this.repositoryLocation.isAuthorNameEnabled());
        this.authorEnabled.setLayoutData((Object)data);
        String name = this.repositoryLocation.getAuthorName() == null ? "" : this.repositoryLocation.getAuthorName();
        data = new GridData(768);
        this.authorInput = new Combo(rootsComposite, 2048);
        this.authorNameHistory = new UserInputHistory(AUTHOR_HISTORY_NAME);
        this.authorInput.setVisibleItemCount(this.authorNameHistory.getDepth());
        this.authorInput.setItems(this.authorNameHistory.getHistory());
        this.authorInput.setText(name);
        this.authorInput.setEnabled(this.repositoryLocation.isAuthorNameEnabled());
        this.authorInput.setLayoutData((Object)data);
        AbstractFormattedVerifier verifier = new AbstractFormattedVerifier("AuthorNameVerifier"){

            @Override
            protected String getErrorMessageImpl(Control input) {
                if (this.getText(input).equals("")) {
                    return SVNUIMessages.NewRepositoryLocationWizard_AuthorName_Verifier;
                }
                return null;
            }

            @Override
            protected String getWarningMessageImpl(Control input) {
                return null;
            }
        };
        this.validationManager.attachTo((Control)this.authorInput, new AbstractVerifierProxy(verifier){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return RepositoryPropertiesTabFolder.this.authorEnabled.getSelection();
            }
        });
        this.authorEnabled.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                RepositoryPropertiesTabFolder.this.authorInput.setEnabled(((Button)event.widget).getSelection());
                RepositoryPropertiesTabFolder.this.validationManager.validateContent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group proxyGroup = new Group(rootsComposite, 0);
        GridLayout proxyGroupLayout = new GridLayout(1, true);
        proxyGroupLayout.marginHeight = 5;
        proxyGroupLayout.marginWidth = 5;
        proxyGroup.setLayout((Layout)proxyGroupLayout);
        proxyGroup.setText(SVNUIMessages.RepositoryPropertiesTabFolder_Proxy);
        data = new GridData(768);
        data.verticalIndent = 10;
        proxyGroup.setLayoutData((Object)data);
        Link proxyLink = new Link((Composite)proxyGroup, 64);
        proxyLink.setText(SVNUIMessages.RepositoryPropertiesTabFolder_Proxy_Link);
        proxyLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String pageId = "org.eclipse.ui.net.NetPreferences";
                PreferencesUtil.createPreferenceDialogOn(null, (String)pageId, (String[])new String[]{pageId}, null).open();
            }
        });
        data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = DefaultDialog.convertHeightInCharsToPixels((Control)this, 3);
        proxyLink.setLayoutData((Object)data);
        tabItem.setControl((Control)rootsComposite);
        this.unavailableSSHComposite = this.createUnavailableComposite((Composite)tabFolder);
        this.unavailableSSHComposite.setVisible(false);
        this.createSSHHostComposite((Composite)tabFolder);
        this.sshComposite.setVisible(false);
        this.sshTab = new TabItem(tabFolder, 0);
        this.sshTab.setText(SVNUIMessages.RepositoryPropertiesTabFolder_SSHSettings);
        if ((CoreExtensionsManager.instance().getSVNConnectorFactory().getSupportedFeatures() & 1) != 0) {
            this.sshTab.setControl((Control)this.sshComposite);
        } else {
            this.sshTab.setControl((Control)this.unavailableSSHComposite);
        }
        this.createSSLHostComposite((Composite)tabFolder);
        this.sslComposite.setVisible(false);
        this.sslTab = new TabItem(tabFolder, 0);
        this.sslTab.setText(SVNUIMessages.RepositoryPropertiesTabFolder_SSLSettings);
        this.sslTab.setControl((Control)this.sslComposite);
        this.unavailableProxyComposite = this.createUnavailableComposite((Composite)tabFolder);
        this.unavailableProxyComposite.setVisible(false);
        Composite bottomPart = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        bottomPart.setLayout((Layout)layout);
        data = new GridData(768);
        bottomPart.setLayoutData((Object)data);
        Composite realmsComposite = new Composite(bottomPart, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        realmsComposite.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 3;
        realmsComposite.setLayoutData((Object)data);
        Label label = new Label(realmsComposite, 0);
        data = new GridData();
        label.setLayoutData((Object)data);
        label.setText(SVNUIMessages.RepositoryPropertiesTabFolder_ShowFor);
        this.cachedRealms = new Combo(realmsComposite, 2056);
        final Button deleteRealm = new Button(realmsComposite, 8);
        data = new GridData(768);
        this.cachedRealms.setLayoutData((Object)data);
        final ArrayList<String> itemSet = new ArrayList<String>();
        itemSet.add("<Repository Location>");
        itemSet.addAll(this.repositoryLocation.getRealms());
        this.cachedRealms.setItems(itemSet.toArray(new String[itemSet.size()]));
        this.cachedRealms.select(0);
        this.cachedRealms.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                deleteRealm.setEnabled(RepositoryPropertiesTabFolder.this.cachedRealms.getSelectionIndex() != 0);
                RepositoryPropertiesTabFolder.this.realmSelectionChanged(false);
            }
        });
        ImageDescriptor imgDescr = SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/delete_realm.gif");
        deleteRealm.setImage(imgDescr.createImage());
        data = new GridData();
        data.heightHint = this.cachedRealms.getTextHeight() + 2;
        deleteRealm.setLayoutData((Object)data);
        deleteRealm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = RepositoryPropertiesTabFolder.this.cachedRealms.getSelectionIndex();
                if (idx != 0) {
                    String item = RepositoryPropertiesTabFolder.this.cachedRealms.getItem(idx);
                    itemSet.remove(item);
                    RepositoryPropertiesTabFolder.this.cachedRealms.setItems(itemSet.toArray(new String[itemSet.size()]));
                    RepositoryPropertiesTabFolder.this.cachedRealms.select(idx - 1);
                    RepositoryPropertiesTabFolder.this.realmSelectionChanged(false);
                }
                boolean enabled = RepositoryPropertiesTabFolder.this.cachedRealms.getItems().length > 1;
                ((Button)e.widget).setEnabled(enabled);
                RepositoryPropertiesTabFolder.this.cachedRealms.setEnabled(enabled);
                idx = RepositoryPropertiesTabFolder.this.cachedRealms.getSelectionIndex();
                if (idx == 0) {
                    ((Button)e.widget).setEnabled(false);
                }
            }
        });
        deleteRealm.setEnabled(false);
        this.cachedRealms.setEnabled(itemSet.size() > 1);
        this.validateButton = new Button(bottomPart, 32);
        data = new GridData(32);
        this.validateButton.setLayoutData((Object)data);
        this.validateButton.setText(SVNUIMessages.RepositoryPropertiesTabFolder_ValidateOnFinish);
        this.validateButton.setSelection(true);
        Text empty = new Text(bottomPart, 8);
        data = new GridData(768);
        empty.setLayoutData((Object)data);
        empty.setVisible(false);
        this.resetChangesButton = new Button(bottomPart, 8);
        data = new GridData(128);
        this.resetChangesButton.setText(SVNUIMessages.RepositoryPropertiesTabFolder_ResetChanges);
        data.widthHint = widthHint = DefaultDialog.computeButtonWidth(this.resetChangesButton);
        this.resetChangesButton.setLayoutData((Object)data);
        this.resetChangesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryPropertiesTabFolder.this.resetChanges();
                RepositoryPropertiesTabFolder.this.validationManager.validateContent();
            }
        });
        if ((this.repositoryLocation.getUsername() == null || this.repositoryLocation.getUsername().length() == 0) && this.repositoryLocation.getRealms().size() > 0) {
            this.cachedRealms.select(1);
            deleteRealm.setEnabled(true);
            this.realmSelectionChanged(true);
        }
    }

    protected void realmSelectionChanged(boolean isFirstTime) {
        IRepositoryLocation location = this.repositoryLocation;
        int idx = this.cachedRealms.getSelectionIndex();
        if (idx != 0) {
            location = location.getLocationForRealm(this.cachedRealms.getItem(idx));
        }
        if (!isFirstTime) {
            this.repositoryPropertiesPanel.saveChanges();
        }
        this.repositoryPropertiesPanel.setCredentialsInput(location, this);
        this.repositoryPropertiesPanel.resetChanges();
        if ((CoreExtensionsManager.instance().getSVNConnectorFactory().getSupportedFeatures() & 1) != 0) {
            if (!isFirstTime) {
                this.sshComposite.saveChanges();
            }
            this.sshComposite.setCredentialsInput(location.getSSHSettings());
            this.sshComposite.resetChanges();
        }
        if (!isFirstTime) {
            this.sslComposite.saveChanges();
        }
        this.sslComposite.setCredentialsInput(location.getSSLSettings());
        this.sslComposite.resetChanges();
    }

    protected Composite createRepositoryPropertiesPanel(Composite tabFolder) {
        this.repositoryPropertiesPanel = new RepositoryPropertiesComposite(tabFolder, this.style, this.validationManager);
        this.repositoryPropertiesPanel.setRepositoryLocation(this.repositoryLocation, this.createNew ? null : this.repositoryLocation.getRepositoryRootUrl(), this);
        this.repositoryPropertiesPanel.initialize();
        return this.repositoryPropertiesPanel;
    }

    protected Composite createSSHHostComposite(Composite tabFolder) {
        this.sshComposite = new SSHComposite(tabFolder, this.style, this.validationManager);
        this.sshComposite.setCredentialsInput(this.repositoryLocation.getSSHSettings());
        this.sshComposite.initialize();
        return this.sshComposite;
    }

    protected Composite createSSLHostComposite(Composite tabFolder) {
        this.sslComposite = new SSLComposite(tabFolder, this.style, this.validationManager);
        this.sslComposite.setCredentialsInput(this.repositoryLocation.getSSLSettings());
        this.sslComposite.initialize();
        return this.sslComposite;
    }

    protected Composite createRepositoryRootsComposite(Composite tabFolder) {
        this.rootsComposite = new RepositoryRootsComposite(tabFolder, this.style, this.validationManager);
        this.rootsComposite.setStructureEnabled(this.repositoryLocation.isStructureEnabled());
        this.rootsComposite.setTrunkLocation(this.repositoryLocation.getUserInputTrunk());
        this.rootsComposite.setBranchesLocation(this.repositoryLocation.getUserInputBranches());
        this.rootsComposite.setTagsLocation(this.repositoryLocation.getUserInputTags());
        this.rootsComposite.setCreateLocation(this.createNew);
        this.rootsComposite.initialize();
        return this.rootsComposite;
    }

    protected Composite createUnavailableComposite(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 64);
        label.setText(SVNUIMessages.RepositoryPropertiesTabFolder_UnavailableMessage);
        Link link = new Link(composite, 0);
        link.setText(SVNUIMessages.RepositoryPropertiesTabFolder_LinkToPreferences);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryPropertiesTabFolder.this.handleLinkSelection();
            }
        });
        return composite;
    }

    public void handleLinkSelection() {
        boolean sshWasAllowed = (CoreExtensionsManager.instance().getSVNConnectorFactory().getSupportedFeatures() & 1) != 0;
        String pageId = "org.eclipse.team.svn.ui.SVNTeamPreferences";
        PreferencesUtil.createPreferenceDialogOn(null, (String)pageId, (String[])new String[]{pageId}, null).open();
        boolean sshAllowed = (CoreExtensionsManager.instance().getSVNConnectorFactory().getSupportedFeatures() & 1) != 0;
        this.updateTabContent(sshWasAllowed, sshAllowed, this.sshTab, this.sshComposite, this.unavailableSSHComposite);
    }

    public void updateTabContent(boolean wasAvailable, boolean isAvailable, TabItem tab, AbstractDynamicComposite availableComposite, Composite unavailableComposite) {
        if (isAvailable) {
            if (!wasAvailable) {
                availableComposite.restoreAppearance();
                tab.setControl((Control)availableComposite);
            }
        } else if (wasAvailable) {
            availableComposite.saveAppearance();
            tab.setControl((Control)unavailableComposite);
            availableComposite.revalidateContent();
        }
    }

    public IRepositoryLocation getRepositoryLocation() {
        return this.repositoryLocation;
    }

    public String getLocationUrl() {
        return this.repositoryPropertiesPanel.getLocationUrl();
    }

    public boolean isStructureEnabled() {
        return this.rootsComposite.isStructureEnabled();
    }

    public boolean isValidateOnFinishRequested() {
        return this.validateOnFinish;
    }

    @Override
    public void saveChanges() {
        this.repositoryPropertiesPanel.saveChanges();
        if ((CoreExtensionsManager.instance().getSVNConnectorFactory().getSupportedFeatures() & 1) != 0) {
            this.sshComposite.saveChanges();
        }
        this.sslComposite.saveChanges();
        this.rootsComposite.saveChanges();
        this.repositoryLocation.setAuthorName(this.authorInput.getText());
        this.repositoryLocation.setAuthorNameEnabled(this.authorEnabled.getSelection());
        this.authorNameHistory.addLine(this.authorInput.getText());
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        boolean enabled = this.rootsComposite.isStructureEnabled();
        if (enabled) {
            this.repositoryLocation.setTrunkLocation(this.rootsComposite.getTrunkLocation());
            this.repositoryLocation.setBranchesLocation(this.rootsComposite.getBranchesLocation());
            this.repositoryLocation.setTagsLocation(this.rootsComposite.getTagsLocation());
        } else if (this.createNew) {
            this.repositoryLocation.setTrunkLocation(SVNTeamPreferences.getRepositoryString(store, "head"));
            this.repositoryLocation.setBranchesLocation(SVNTeamPreferences.getRepositoryString(store, "branches"));
            this.repositoryLocation.setTagsLocation(SVNTeamPreferences.getRepositoryString(store, "tags"));
        }
        this.repositoryLocation.setStructureEnabled(enabled);
        HashSet<String> realms = new HashSet<String>(Arrays.asList(this.cachedRealms.getItems()));
        Iterator it = this.repositoryLocation.getRealms().iterator();
        while (it.hasNext()) {
            String current = (String)it.next();
            if (realms.contains(current)) continue;
            it.remove();
            SVNRemoteStorage.instance().removeAuthInfoForLocation(this.repositoryLocation, current);
        }
        this.validateOnFinish = this.validateButton.getSelection();
    }

    @Override
    public void resetChanges() {
        this.repositoryPropertiesPanel.resetChanges();
        if ((CoreExtensionsManager.instance().getSVNConnectorFactory().getSupportedFeatures() & 1) != 0) {
            this.sshComposite.resetChanges();
        }
        this.sslComposite.resetChanges();
        this.rootsComposite.resetChanges();
    }

    @Override
    public void cancelChanges() {
        if (!this.createNew) {
            SVNRemoteStorage.instance().copyRepositoryLocation(this.repositoryLocation, this.backup);
        }
    }

    public void setForceDisableRoots(boolean forceDisableRoots, AbstractVerifier verifier) {
        if (this.rootsComposite != null) {
            this.rootsComposite.setForceDisableRoots(forceDisableRoots);
        }
        if (this.repositoryPropertiesPanel != null) {
            this.repositoryPropertiesPanel.defineUrlVerifier(verifier);
        }
    }
}

