/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.composite;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.PathSelectionComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.common.DiffViewerVariablesPanel;
import org.eclipse.team.svn.ui.verifier.IValidationManager;

public class DiffViewerExternalProgramComposite
extends Composite {
    protected IValidationManager validationManager;
    protected String groupLabel;
    protected List<Control> controls = new ArrayList<Control>();
    protected PathSelectionComposite pathComposite;
    protected Text parametersText;
    protected String programParameters;

    public DiffViewerExternalProgramComposite(String groupLabel, Composite parent, IValidationManager validationManager) {
        super(parent, 0);
        this.groupLabel = groupLabel;
        this.validationManager = validationManager;
        this.createControls();
    }

    public void setProgramPath(String programPath) {
        if (programPath != null) {
            this.pathComposite.setSelectedPath(programPath);
        }
    }

    public String getProgramPath() {
        return this.pathComposite.getSelectedPath();
    }

    public String getProgramParameters() {
        return this.programParameters;
    }

    public void setProgramParameters(String programParameters) {
        if (programParameters != null) {
            this.parametersText.setText(programParameters);
        }
    }

    protected void createControls() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        GridData data = new GridData(768);
        this.setLayout((Layout)layout);
        this.setLayoutData(data);
        Group parametersGroup = new Group((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        data = new GridData(768);
        parametersGroup.setLayout((Layout)layout);
        parametersGroup.setLayoutData((Object)data);
        parametersGroup.setText(this.groupLabel);
        this.pathComposite = new PathSelectionComposite(SVNUIMessages.DiffViewerExternalProgramComposite_Path_LabelName, SVNUIMessages.DiffViewerExternalProgramComposite_Path_FieldName, SVNUIMessages.DiffViewerExternalProgramComposite_Path_BrowseDialogTitle, null, false, (Composite)parametersGroup, this.validationManager);
        this.controls.add((Control)this.pathComposite);
        this.parametersText = new Text((Composite)parametersGroup, 2882);
        data = new GridData(1808);
        data.heightHint = DefaultDialog.convertHeightInCharsToPixels((Control)this.parametersText, 5);
        this.parametersText.setLayoutData((Object)data);
        this.controls.add((Control)this.parametersText);
        Button variablesButton = new Button((Composite)parametersGroup, 8);
        variablesButton.setText(SVNUIMessages.DiffViewerExternalProgramComposite_Variables_Button);
        data = new GridData();
        data.horizontalAlignment = 131072;
        data.widthHint = DefaultDialog.computeButtonWidth(variablesButton);
        variablesButton.setLayoutData((Object)data);
        this.controls.add((Control)variablesButton);
        variablesButton.addListener(13, event -> {
            DiffViewerVariablesPanel panel = new DiffViewerVariablesPanel();
            DefaultDialog dlg = new DefaultDialog(this.getShell(), panel);
            if (dlg.open() == 0) {
                String variable = panel.getVariable();
                this.parametersText.insert(variable);
            }
        });
        this.parametersText.addModifyListener(e -> {
            String string = this.programParameters = ((Text)e.widget).getText();
        });
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Control control : this.controls) {
            control.setEnabled(enabled);
        }
    }
}

