/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.compare.PropertyCompareInput;

public class TwoWayPropertyCompareInput
extends PropertyCompareInput {
    public TwoWayPropertyCompareInput(CompareConfiguration configuration, SVNEntryRevisionReference left, SVNEntryRevisionReference right, IRepositoryLocation location) {
        super(configuration, left, right, null, location);
    }

    @Override
    protected void fillMenu(IMenuManager manager, TreeSelection selection) {
    }

    public String getTitle() {
        String nameRight;
        String nameLeft = this.left.path.substring(this.left.path.lastIndexOf("/") + 1);
        if (nameLeft.equals(nameRight = this.right.path.substring(this.right.path.lastIndexOf("/") + 1))) {
            return BaseMessages.format((String)SVNUIMessages.PropertyCompareInput_Title2, (Object[])new String[]{nameLeft + " [" + this.getRevisionPart(this.left), this.getRevisionPart(this.right) + "] "});
        }
        return BaseMessages.format((String)SVNUIMessages.PropertyCompareInput_Title2, (Object[])new String[]{nameLeft + " [" + this.getRevisionPart(this.left) + "]", nameRight + " [" + this.getRevisionPart(this.right) + "] "});
    }

    @Override
    protected String getRevisionPart(SVNEntryRevisionReference reference) {
        return BaseMessages.format((String)SVNUIMessages.ResourceCompareInput_RevisionSign, (Object[])new String[]{String.valueOf(reference.revision)});
    }
}

