/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.writer.IOrcsValidationHelper;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;

public class OrcsValidationHelperAdapter
implements IOrcsValidationHelper {
    private final QueryFactory queryFactory;
    private final OrcsTokenService tokenService;

    public OrcsValidationHelperAdapter(OrcsApi orcsApi) {
        this.queryFactory = orcsApi.getQueryFactory();
        this.tokenService = orcsApi.tokenService();
    }

    @Override
    public boolean isBranchExists(BranchId branch) {
        return ((BranchQuery)this.queryFactory.branchQuery().andId(branch)).getResultsAsId().size() == 1;
    }

    @Override
    public boolean isUserExists(String userId) {
        return ((ArtifactReadable)this.queryFactory.fromBranch((BranchId)CoreBranches.COMMON).andAttributeIs((AttributeTypeId)CoreAttributeTypes.UserId, userId).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL)).isValid();
    }

    @Override
    public boolean isArtifactExists(BranchId branch, long artifactUuid) {
        return this.queryFactory.fromBranch(branch).andUuid(artifactUuid).exists();
    }

    @Override
    public boolean isArtifactTypeExist(long artifactTypeUuid) {
        return this.tokenService.getArtifactType(Long.valueOf(artifactTypeUuid)) != null;
    }

    @Override
    public boolean isApplicabilityExist(BranchId branch, String value) {
        return this.queryFactory.applicabilityQuery().featureExistsOnBranch(branch, value);
    }

    @Override
    public boolean isRelationTypeExist(long relationTypeUuid) {
        return this.tokenService.getRelationType(Long.valueOf(relationTypeUuid)) != null;
    }

    @Override
    public boolean isAttributeTypeExists(long attributeTypeUuid) {
        return this.tokenService.getAttributeType(Long.valueOf(attributeTypeUuid)) != null;
    }
}

