/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.health.ServerStatus;
import org.eclipse.osee.orcs.health.StatusKey;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerUtils;

public class ServerHealthOverviewDetails {
    private final JdbcClient jdbcClient;
    private final boolean details;

    public ServerHealthOverviewDetails(JdbcClient jdbcClient, boolean details) {
        this.jdbcClient = jdbcClient;
        this.details = details;
    }

    public String getHtml() {
        List<String> servers = ServerUtils.getServers(this.jdbcClient);
        if (servers.size() == 0) {
            return AHTML.simplePage((String)"No osee.health.servers configured in osee_info table");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<h3>Server Status</h3>");
        sb.append(AHTML.beginMultiColumnTable((int)95, (int)2));
        LinkedList<String> headers = new LinkedList<String>();
        headers.add("Name");
        headers.add("Alive");
        StatusKey[] statusKeyArray = StatusKey.values();
        int n = statusKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatusKey key = statusKeyArray[n2];
            if (this.details || !key.isDetails()) {
                headers.add(key.name());
            }
            ++n2;
        }
        sb.append(AHTML.addHeaderRowMultiColumnTable(headers));
        for (String server : servers) {
            this.addServer(sb, server, this.details);
        }
        sb.append(AHTML.endMultiColumnTable());
        return AHTML.simplePage((String)sb.toString());
    }

    private void addServer(StringBuilder sb, String server, boolean details) {
        LinkedList<String> values = new LinkedList<String>();
        String statusUrl = "http://" + server + "/server/health/status";
        values.add(AHTML.getHyperlink((String)statusUrl, (String)server));
        try {
            String urlStr = String.format("http://%s%s", server, "/server/health/status");
            String results = ServerUtils.getUrlResults(urlStr);
            if (results.contains("{\"data\" ")) {
                values.add("Ok");
                ServerStatus stat = (ServerStatus)JsonUtil.readValue((String)results, ServerStatus.class);
                StatusKey[] statusKeyArray = StatusKey.values();
                int n = statusKeyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StatusKey key = statusKeyArray[n2];
                    if (details || !key.isDetails()) {
                        String value = stat.get(key);
                        if (value == null) {
                            value = "";
                        }
                        values.add(value);
                    }
                    ++n2;
                }
            } else {
                values.add("Not successful: " + results);
            }
        }
        catch (Exception ex) {
            values.add("Exception: " + ex.getMessage());
        }
        sb.append(AHTML.addRowMultiColumnTable((String[])values.toArray(new String[values.size()])));
    }
}

