/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.ArtifactEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.BranchResource;
import org.eclipse.osee.orcs.rest.internal.GridCommanderEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.HtmlWriter;
import org.eclipse.osee.orcs.rest.internal.RelationEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.TupleEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.applicability.ApplicabilityEndpointImpl;
import org.eclipse.osee.orcs.rest.model.ApplicabilityEndpoint;
import org.eclipse.osee.orcs.rest.model.ArtifactEndpoint;
import org.eclipse.osee.orcs.rest.model.GridCommanderEndpoint;
import org.eclipse.osee.orcs.rest.model.RelationEndpoint;
import org.eclipse.osee.orcs.rest.model.TupleEndpoint;
import org.eclipse.osee.orcs.search.BranchQuery;

@Path(value="branch")
public class BranchesResource {
    private final OrcsApi orcsApi;
    @Context
    UriInfo uriInfo;

    public BranchesResource(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    @Path(value="{uuid}")
    public BranchResource getBranch(@PathParam(value="uuid") BranchId id) {
        return new BranchResource(this.uriInfo, id, this.orcsApi);
    }

    @POST
    @Path(value="nameQuery")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public BranchId getBranchByName(String branchName) {
        return (BranchId)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andNameEquals(branchName)).getResults().getExactlyOne();
    }

    @GET
    @Produces(value={"text/html"})
    public String getAsHtml() {
        BranchQuery query = this.orcsApi.getQueryFactory().branchQuery();
        ResultSet results = ((BranchQuery)query.andIsOfType(new BranchType[]{BranchType.BASELINE, BranchType.WORKING})).getResults();
        HtmlWriter writer = new HtmlWriter(this.uriInfo, this.orcsApi);
        return writer.toHtml((Iterable<? extends Object>)results);
    }

    @Path(value="{branch}/tuple")
    public TupleEndpoint getTuples(@PathParam(value="branch") BranchId branch) {
        return new TupleEndpointImpl(this.orcsApi, branch);
    }

    @Path(value="{branch}/applic")
    public ApplicabilityEndpoint getApplicability(@PathParam(value="branch") BranchId branch) {
        return new ApplicabilityEndpointImpl(this.orcsApi, branch);
    }

    @Path(value="{branch}/artifact")
    public ArtifactEndpoint getArtifact(@PathParam(value="branch") BranchId branch) {
        return new ArtifactEndpointImpl(this.orcsApi, branch, this.uriInfo);
    }

    @Path(value="{branch}/relation")
    public RelationEndpoint getRelation(@PathParam(value="branch") BranchId branch) {
        return new RelationEndpointImpl(this.orcsApi, branch);
    }

    @Path(value="{branch}/gc")
    public GridCommanderEndpoint getGridCommander(@PathParam(value="branch") BranchId branch) {
        return new GridCommanderEndpointImpl(this.orcsApi, branch, this.uriInfo);
    }
}

