/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.publishingdom;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.osee.define.operations.synchronization.identifier.Identifier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AttributeDefinitionImpl;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AttributeValueImpl;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentMap;
import org.eclipse.osee.define.operations.synchronization.publishingdom.Node;
import org.eclipse.osee.framework.jdk.core.util.RankLinkedHashMap;
import org.eclipse.osee.framework.jdk.core.util.RankMap;

class AbstractNode
implements Node {
    protected final RankMap<AttributeValueImpl> attributeValueMap;
    protected final Map<Identifier, AttributeDefinitionImpl> attributeDefinitionMap;
    protected DocumentMap documentMap;
    protected final Identifier nodeIdentifier;
    protected Identifier parentIdentifier;
    private static Predicate<Object>[] keysAreIdentifiers = new Predicate[]{key -> Objects.nonNull(key) && key instanceof Identifier && ((Identifier)key).isType(IdentifierType.ATTRIBUTE_DEFINITION), key -> Objects.nonNull(key) && key instanceof Identifier && ((Identifier)key).isType(IdentifierType.ATTRIBUTE_VALUE)};

    AbstractNode(DocumentMap documentMap, Identifier nodeIdentifier) {
        assert (Objects.nonNull(documentMap)) : "AbstractNode::new, parameter \"documentMap\" cannot be null.";
        assert (Objects.nonNull(nodeIdentifier)) : "AbstractNode::new, parameter \"nodeIdentifier\" cannot be null.";
        this.documentMap = documentMap;
        this.parentIdentifier = null;
        this.nodeIdentifier = nodeIdentifier;
        this.attributeDefinitionMap = new LinkedHashMap<Identifier, AttributeDefinitionImpl>(32, 0.75f);
        this.attributeValueMap = new RankLinkedHashMap("attributeMap", 2, 32, 0.75f, (Predicate[])keysAreIdentifiers);
    }

    void append(Node childNode) {
        assert (Objects.nonNull(childNode)) : "AbstractNode:append, parameter \"childNode\" is null.";
        if (!this.isAttached()) {
            throw new IllegalStateException();
        }
        if (!childNode.isAttached()) {
            throw new IllegalStateException();
        }
        if (childNode.isType(IdentifierType.ATTRIBUTE_DEFINITION)) {
            assert (childNode instanceof AttributeDefinitionImpl) : "AbstractNode:apend, parameter \"childNode\" has an identifier type of \"ATTRIBUTE_DEFINITION\" and is not of class \"AttributeDefinitionImpl\".";
            AttributeDefinitionImpl attributeDefinition = (AttributeDefinitionImpl)childNode;
            this.attributeDefinitionMap.put(attributeDefinition.getIdentifier(), attributeDefinition);
            return;
        }
        if (childNode.isType(IdentifierType.ATTRIBUTE_VALUE)) {
            assert (childNode instanceof AttributeValueImpl) : "AbstractNode:apend, parameter \"childNode\" has an identifier type of \"ATTRIBUTE_VALUE\" and is not of class \"AttributeValueImpl\".";
            AttributeValueImpl attributeValue = (AttributeValueImpl)childNode;
            this.attributeValueMap.associate((Object)attributeValue, new Object[]{attributeValue.getParentIdentifier(), attributeValue.getIdentifier()});
            return;
        }
    }

    void attach(Identifier parentIdentifier) {
        assert (Objects.nonNull(parentIdentifier)) : "AbstractNode::new, parameter \"parentIdentifier\" cannot be null.";
        if (!(this instanceof AttributeDefinitionImpl) && this.isAttached()) {
            throw new IllegalStateException();
        }
        this.parentIdentifier = parentIdentifier;
    }

    @Override
    public int attributeDefinitionSize() {
        return this.attributeDefinitionMap.size();
    }

    @Override
    public Identifier getIdentifier() {
        return this.nodeIdentifier;
    }

    @Override
    public Identifier getParentIdentifier() {
        return this.parentIdentifier;
    }

    @Override
    public IdentifierType getType() {
        return this.nodeIdentifier.getType();
    }

    @Override
    public boolean isAttached() {
        return Objects.nonNull(this.parentIdentifier);
    }

    @Override
    public boolean isType(IdentifierType identifierType) {
        return this.nodeIdentifier.isType(identifierType);
    }

    @Override
    public Stream<AttributeDefinitionImpl> streamAttributeDefinitionChildren() {
        return this.attributeDefinitionMap.values().stream();
    }

    @Override
    public boolean isHierarchical() {
        return false;
    }
}

