/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.publishingdom;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.define.operations.synchronization.identifier.Identifier;
import org.eclipse.osee.define.operations.synchronization.publishingdom.AbstractNode;
import org.eclipse.osee.define.operations.synchronization.publishingdom.DocumentMap;
import org.eclipse.osee.define.operations.synchronization.publishingdom.HierarchicalNode;
import org.eclipse.osee.define.operations.synchronization.publishingdom.HierarchicalNodeSetter;
import org.eclipse.osee.define.operations.synchronization.publishingdom.Node;
import org.eclipse.osee.framework.jdk.core.util.Message;

class AbstractHierarchicalNode
extends AbstractNode
implements HierarchicalNode,
HierarchicalNodeSetter {
    private int[] hierarchyLevels = null;
    private String hierarchyLevelsString = null;
    protected final Map<Identifier, HierarchicalNode> hierarchicalNodeMap = new LinkedHashMap<Identifier, HierarchicalNode>(64, 0.75f);

    AbstractHierarchicalNode(DocumentMap documentMap, Identifier nodeIdentifier) {
        super(documentMap, nodeIdentifier);
    }

    @Override
    void append(Node childNode) {
        if (!(childNode instanceof AbstractHierarchicalNode)) {
            super.append(childNode);
            return;
        }
        assert (Objects.nonNull(childNode)) : "AbstractHierarchicalNode:append, parameter \"childNode\" is null.";
        assert (!this.hierarchicalNodeMap.containsKey(childNode.getIdentifier())) : new Message().title((CharSequence)"AbstractHierarchicalNode::append, AbstractHierarchicalNode already has a child with the \"childNode\" parameter's identifier.").indentInc().segment((CharSequence)"AbstractNode Identifier", (Object)childNode.getIdentifier()).toString();
        if (!this.isAttached()) {
            throw new IllegalStateException();
        }
        if (!childNode.isAttached()) {
            throw new IllegalStateException();
        }
        this.hierarchicalNodeMap.put(childNode.getIdentifier(), (HierarchicalNode)childNode);
    }

    @Override
    public int getHierarchyLevel() {
        return Objects.nonNull(this.hierarchyLevels) ? this.hierarchyLevels.length : -1;
    }

    @Override
    public int hierarchicalSize() {
        return this.hierarchicalNodeMap.size();
    }

    @Override
    public void setHierarchyLevels(int[] hierarchyLevels) {
        Objects.requireNonNull(hierarchyLevels, "DocumentImpl:setHierarchyLevels, parameter \"hierarchyLevels\" cannot be null.");
        if (Objects.nonNull(this.hierarchyLevels)) {
            throw new IllegalStateException("Object::setHierarchyLevels, member \"hierarchyLevels\" has already been set.");
        }
        this.hierarchyLevels = hierarchyLevels;
        this.hierarchyLevelsString = Arrays.stream(this.hierarchyLevels).map(level -> level + 1).mapToObj(Integer::toString).collect(Collectors.joining("."));
    }

    @Override
    public Stream<HierarchicalNode> streamHierarchicalChildren() {
        return this.hierarchicalNodeMap.values().stream();
    }

    @Override
    public String getHierarchyLevelString() {
        return this.hierarchyLevelsString;
    }

    @Override
    public int[] getHierarchyLevels() {
        return Arrays.copyOf(this.hierarchyLevels, this.hierarchyLevels.length);
    }

    @Override
    public boolean isHierarchical() {
        return true;
    }
}

