/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.identifier;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.define.operations.synchronization.identifier.DuplicateIdentifierException;
import org.eclipse.osee.define.operations.synchronization.identifier.Identifier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierTracker;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;

public class IdentifierTrackerPatternMatching
implements IdentifierTracker {
    StringBuilder stringBuilder;
    IdentifierType identifierType;
    Long identifierCount;
    Pattern primaryIdentifierPattern;
    Map<String, Identifier> allocatedIdentifiers;

    IdentifierTrackerPatternMatching(IdentifierType identifierType) {
        this.identifierType = Objects.requireNonNull(identifierType);
        this.allocatedIdentifiers = new HashMap<String, Identifier>();
        this.identifierCount = 0L;
        this.stringBuilder = new StringBuilder();
        this.primaryIdentifierPattern = Pattern.compile("(".concat(identifierType.getIdentifierPrefix()).concat(")-([0-9]+)"));
    }

    @Override
    public synchronized Identifier create(String foreignIdentifierString) {
        Identifier identifier;
        if (Objects.isNull(foreignIdentifierString)) {
            throw new IllegalStateException();
        }
        Matcher matcher = this.primaryIdentifierPattern.matcher(foreignIdentifierString);
        if (matcher.matches()) {
            if (this.allocatedIdentifiers.containsKey(foreignIdentifierString)) {
                throw new DuplicateIdentifierException(this.identifierType, foreignIdentifierString);
            }
            String numericPart = matcher.group(2);
            Long identifierCount = Long.valueOf(numericPart);
            identifier = new Identifier(foreignIdentifierString, identifierCount, this.identifierType);
        } else {
            this.stringBuilder.setLength(0);
            foreignIdentifierString = this.stringBuilder.append(this.identifierType.getIdentifierPrefix()).append("-G-").append(Long.toString(this.identifierCount, 10)).toString();
            Long l = this.identifierCount;
            this.identifierCount = l + 1L;
            identifier = new Identifier(foreignIdentifierString, l, this.identifierType);
        }
        this.allocatedIdentifiers.put(foreignIdentifierString, identifier);
        return identifier;
    }

    @Override
    public Optional<Identifier> getPrimaryIdentifierByForeignIdentifierString(String identifierString) {
        return Optional.ofNullable(this.allocatedIdentifiers.get(identifierString));
    }
}

