/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.template.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.template.engine.AppendableRule;

public class StringOptionsRule
extends AppendableRule<String> {
    private final String listId;
    private final List<String> options = new ArrayList<String>();

    protected String getListId() {
        return this.listId;
    }

    public StringOptionsRule(String ruleName) {
        this(ruleName, null);
    }

    public StringOptionsRule(String ruleName, String listId) {
        super(ruleName);
        this.listId = listId;
    }

    @Override
    public void applyTo(Appendable appendable) throws IOException {
        if (this.listId == null) {
            this.appendOptions(appendable);
        } else {
            appendable.append("\n<datalist id=\"");
            appendable.append(this.listId);
            appendable.append("\">\n");
            this.appendOptions(appendable);
            appendable.append("</datalist>\n");
        }
    }

    private void appendOptions(Appendable appendable) throws IOException {
        for (String option : this.getOptions()) {
            appendable.append("<option value=\"");
            appendable.append(option);
            appendable.append("\" guid=\"");
            appendable.append(option);
            appendable.append("\">\n");
        }
    }

    public List<String> getOptions() {
        return this.options;
    }
}

