/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.util;

import org.eclipse.osee.framework.core.enums.QueryOption;

public class CheckedOptions {
    private QueryOption orderType;
    private QueryOption caseType;
    private QueryOption countType;
    private QueryOption delimiter;
    private QueryOption exists;

    public CheckedOptions(QueryOption ... options) {
        this.initialize(options);
    }

    private void initialize(QueryOption ... options) {
        this.orderType = QueryOption.TOKEN_MATCH_ORDER__ANY;
        this.caseType = QueryOption.CASE__IGNORE;
        this.countType = QueryOption.TOKEN_COUNT__IGNORE;
        this.delimiter = QueryOption.TOKEN_DELIMITER__ANY;
        QueryOption[] queryOptionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            QueryOption option = queryOptionArray[n2];
            switch (option) {
                case CASE__MATCH: 
                case CASE__IGNORE: {
                    this.caseType = option;
                    break;
                }
                case TOKEN_COUNT__MATCH: 
                case TOKEN_COUNT__IGNORE: {
                    this.countType = option;
                    break;
                }
                case TOKEN_DELIMITER__EXACT: 
                case TOKEN_DELIMITER__WHITESPACE: 
                case TOKEN_DELIMITER__ANY: {
                    this.delimiter = option;
                    break;
                }
                case TOKEN_MATCH_ORDER__ANY: 
                case TOKEN_MATCH_ORDER__MATCH: {
                    this.orderType = option;
                }
            }
            ++n2;
        }
    }

    public QueryOption getOrderType() {
        return this.orderType;
    }

    public QueryOption getCaseType() {
        return this.caseType;
    }

    public QueryOption getCountType() {
        return this.countType;
    }

    public QueryOption getDelimiter() {
        return this.delimiter;
    }

    public QueryOption getExists() {
        return this.exists;
    }
}

