/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaBranchCategory;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class BranchCategorySqlHandler
extends SqlHandler<CriteriaBranchCategory> {
    private CriteriaBranchCategory criteria;
    private String brcAlias;
    private String brAlias;
    private String txAlias;

    @Override
    public void setData(CriteriaBranchCategory criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.brAlias = writer.getMainTableAlias(OseeDb.BRANCH_TABLE);
        this.brcAlias = writer.getMainTableAlias(OseeDb.BRANCH_CATEGORY);
        this.txAlias = writer.getMainTableAlias(OseeDb.TXS_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.write("%s.category = ? and ", this.brcAlias);
        writer.write("%s.branch_id = %s.branch_id and ", this.brAlias, this.brcAlias);
        writer.write("%s.branch_id = %s.branch_id and ", this.brAlias, this.txAlias);
        writer.write("%s.tx_current = ? and ", this.txAlias);
        writer.write("%s.gamma_id = %s.gamma_id", this.brcAlias, this.txAlias);
        writer.addParameter(this.criteria.getBranchCategory());
        writer.addParameter(TxCurrent.CURRENT);
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.BRANCH_CATEGORY.ordinal();
    }
}

