/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;

public enum SQL3DataType {
    BIT(-7, Boolean.class),
    TINYINT(-6, Integer.class),
    SMALLINT(5, Integer.class),
    INTEGER(4, Integer.class),
    BIGINT(-5, Long.class),
    FLOAT(6, Float.class),
    REAL(7, Double.class),
    DOUBLE(8, Double.class),
    NUMERIC(2, Double.class),
    DECIMAL(3, Integer.class),
    CHAR(1, Character.class),
    VARCHAR(12, String.class),
    LONGVARCHAR(-1, String.class),
    DATE(91, Date.class),
    TIME(92, Time.class),
    TIMESTAMP(93, Timestamp.class),
    BINARY(-2, Object.class),
    VARBINARY(-3, Object.class),
    LONGVARBINARY(-4, Object.class),
    NULL(0, Object.class),
    OTHER(1111, Object.class),
    JAVA_OBJECT(2000, Object.class),
    DISTINCT(2001, Object.class),
    STRUCT(2002, Object.class),
    ARRAY(2003, Object.class),
    BLOB(2004, Object.class),
    CLOB(2005, Object.class),
    REF(2006, Object.class),
    DATALINK(70, Object.class),
    BOOLEAN(16, Boolean.class);

    private Class<?> javaClassEquivalent;
    private int sqlTypeNumber;
    private static HashMap<Integer, SQL3DataType> typeToEnum;

    static {
        typeToEnum = new HashMap();
    }

    private SQL3DataType(int sqlTypeNumber, Class<?> classEquiv) {
        this.javaClassEquivalent = classEquiv;
        this.sqlTypeNumber = sqlTypeNumber;
    }

    public int getSQLTypeNumber() {
        return this.sqlTypeNumber;
    }

    public Class<?> getJavaEquivalentClass() {
        return this.javaClassEquivalent;
    }

    public static SQL3DataType get(int type) {
        if (typeToEnum.isEmpty()) {
            SQL3DataType[] sQL3DataTypeArray = SQL3DataType.values();
            int n = sQL3DataTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SQL3DataType enumType = sQL3DataTypeArray[n2];
                typeToEnum.put(enumType.sqlTypeNumber, enumType);
                ++n2;
            }
        }
        return typeToEnum.get(type);
    }
}

