/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnToken;
import org.eclipse.osee.ats.api.column.AtsColumnTokens;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.AtsWorldEndpointApi;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.rest.AtsApiServer;
import org.eclipse.osee.ats.rest.internal.world.AtsWorldResultRowOperation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.ResultRows;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

@Path(value="world")
public class AtsWorldEndpointImpl
implements AtsWorldEndpointApi {
    private final AtsApiServer atsApiServer;
    private final AtsApi atsApi;
    public static final List<String> namespaces = Arrays.asList("WorldXViewer", "BacklogXViewer", "SprintXViewer", "GoalXViewer", "TaskXViewer");

    public AtsWorldEndpointImpl(AtsApiServer atsApiServer) {
        this.atsApiServer = atsApiServer;
        this.atsApi = atsApiServer;
    }

    @GET
    @Path(value="cust/global")
    @Produces(value={"application/json"})
    public Collection<CustomizeData> getCustomizationsGlobal() {
        LinkedList<CustomizeData> datas = new LinkedList<CustomizeData>();
        for (String namespace : namespaces) {
            datas.addAll(this.atsApiServer.getCustomizationsGlobal(namespace));
        }
        return datas;
    }

    @GET
    @Path(value="cust")
    @Produces(value={"application/json"})
    public Collection<CustomizeData> getCustomizations() {
        LinkedList<CustomizeData> datas = new LinkedList<CustomizeData>();
        for (String namespace : namespaces) {
            datas.addAll(this.atsApiServer.getCustomizations(namespace));
        }
        return datas;
    }

    @GET
    @Path(value="my/{userArtId}")
    @Produces(value={"application/json"})
    public Collection<IAtsWorkItem> getMyWorld(@PathParam(value="userArtId") ArtifactId userArtId) {
        ArtifactReadable userArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(userArtId);
        AtsUser userById = this.atsApiServer.getUserService().getUserByUserId((String)userArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.UserId));
        Collection myWorldItems = this.atsApiServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAssignee(new AtsUser[]{userById}).getItems(IAtsWorkItem.class);
        return myWorldItems;
    }

    @GET
    @Path(value="my/{userArtId}/ui")
    @Produces(value={"text/html"})
    public String getMyWorldUI(@PathParam(value="userArtId") ArtifactId userArtId) {
        StringBuilder sb = new StringBuilder();
        ArtifactReadable userArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(userArtId);
        AtsUser userById = this.atsApiServer.getUserService().getUserByUserId((String)userArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.UserId));
        Collection myWorldItems = this.atsApiServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAssignee(new AtsUser[]{userById}).getItems(IAtsWorkItem.class);
        this.getDefaultUiTable(sb, "My World - " + userById.getName(), myWorldItems);
        return sb.toString();
    }

    @GET
    @Path(value="my/{userArtId}/ui/{customizeGuid}")
    @Produces(value={"text/html"})
    public String getMyWorldUICustomized(@PathParam(value="userArtId") ArtifactId userArtId, @PathParam(value="customizeGuid") String customizeGuid) {
        ArtifactReadable userArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(userArtId);
        AtsUser userById = this.atsApiServer.getUserService().getUserByUserId((String)userArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.UserId));
        Conditions.checkNotNull((Object)userById, (String)("User by Id " + userArtId));
        CustomizeData customization = this.atsApiServer.getStoreService().getCustomizationByGuid(customizeGuid);
        if (customization == null) {
            return AHTML.simplePage((String)String.format("No customization found with id [%s]", customizeGuid));
        }
        Collection myWorldItems = this.atsApiServer.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAssignee(new AtsUser[]{userById}).getItems(IAtsWorkItem.class);
        String table = AtsWorldEndpointImpl.getCustomizedTable(this.atsApiServer, "MY World - " + userById.getName() + " - Customization: " + customization.getName(), customization, myWorldItems);
        return table;
    }

    @GET
    @Path(value="coll/{collectorId}")
    @Produces(value={"application/json"})
    public Collection<IAtsWorkItem> getCollection(@PathParam(value="collectorId") ArtifactId collectorId) {
        ArtifactReadable collectorArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(collectorId);
        return this.getCollection(collectorArt);
    }

    private Collection<IAtsWorkItem> getCollection(ArtifactReadable collectorArt) {
        ArrayList<IAtsWorkItem> myWorldItems = new ArrayList<IAtsWorkItem>();
        if (collectorArt != null) {
            if (collectorArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                myWorldItems.addAll(this.atsApiServer.getWorkItemService().getWorkItems((Collection)collectorArt.getRelated(AtsRelationTypes.Goal_Member).getList()));
            } else if (collectorArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
                myWorldItems.addAll(this.atsApiServer.getWorkItemService().getWorkItems((Collection)collectorArt.getRelated(AtsRelationTypes.AgileSprintToItem_AtsItem).getList()));
            }
        }
        return myWorldItems;
    }

    @GET
    @Path(value="coll/{collectorId}/ui")
    @Produces(value={"text/html"})
    public String getCollectionUI(@PathParam(value="collectorId") ArtifactId collectorId) {
        StringBuilder sb = new StringBuilder();
        ArtifactReadable collectorArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(collectorId);
        this.getDefaultUiTable(sb, "Collection - " + collectorArt.getName(), this.getCollection(collectorId));
        return sb.toString();
    }

    @GET
    @Path(value="coll/{collectorId}/ui/{customizeGuid}")
    @Produces(value={"text/html"})
    public String getCollectionUICustomized(@PathParam(value="collectorId") ArtifactId collectorId, @PathParam(value="customizeGuid") String customizeGuid) {
        CustomizeData customization = this.atsApiServer.getStoreService().getCustomizationByGuid(customizeGuid);
        ArtifactReadable collectorArt = (ArtifactReadable)this.atsApiServer.getQueryService().getArtifact(collectorId);
        Collection<IAtsWorkItem> collectorItems = this.getCollection(collectorArt);
        if (customization == null) {
            return "";
        }
        String table = AtsWorldEndpointImpl.getCustomizedTable(this.atsApiServer, "Collector - " + collectorArt.getName() + " - Customization: " + customization.getName(), customization, collectorItems);
        return table;
    }

    public static String getCustomizedTable(AtsApi atsApi, String title, CustomizeData customization, Collection<IAtsWorkItem> workItems) {
        Conditions.checkNotNull((Object)customization, (String)("Customization " + customization + " "));
        StringBuilder sb = new StringBuilder();
        sb.append(AHTML.heading((int)2, (String)title));
        sb.append(AHTML.beginMultiColumnTable((int)97, (int)1));
        ArrayList<String> headers = new ArrayList<String>();
        for (XViewerColumn col : customization.getColumnData().getColumns()) {
            if (!col.isShow()) continue;
            headers.add(col.getName());
        }
        headers.add("Link");
        sb.append(AHTML.addHeaderRowMultiColumnTable(headers));
        AtsConfigurations configurations = atsApi.getConfigService().getConfigurations();
        for (IAtsWorkItem workItem : workItems) {
            ArrayList<String> rowStrs = new ArrayList<String>();
            ArrayList<String> colOptions = new ArrayList<String>();
            for (XViewerColumn col : customization.getColumnData().getColumns()) {
                if (!col.isShow()) continue;
                String text = "";
                if (Strings.isValid((String)col.getId())) {
                    text = atsApi.getColumnService().getColumnText(configurations, col.getId(), (IAtsObject)workItem);
                }
                rowStrs.add(text);
                colOptions.add("");
            }
            rowStrs.add(AHTML.getHyperlinkNewTab((String)("/ats/ui/action/" + workItem.getAtsId()), (String)"open"));
            colOptions.add("");
            sb.append(AHTML.addRowMultiColumnTable((String[])rowStrs.toArray(new String[rowStrs.size()]), null));
        }
        sb.append(AHTML.endMultiColumnTable());
        return sb.toString();
    }

    private void getDefaultUiTable(StringBuilder sb, String tableName, Collection<IAtsWorkItem> workItems) {
        List<AtsColumnToken> columns = Arrays.asList(AtsColumnTokens.TeamColumn, AtsColumnTokens.StateColumn, AtsColumnTokens.PriorityColumn, AtsColumnTokens.ChangeTypeColumn, AtsColumnTokens.AssigneeColumn, AtsColumnTokens.TitleColumn, AtsColumnTokens.ActionableItemsColumn, AtsColumnTokens.CreatedDateColumn, AtsColumnTokens.TargetedVersionColumn, AtsColumnTokens.NotesColumn, AtsColumnTokens.AtsIdColumn);
        sb.append(AHTML.heading((int)2, (String)tableName));
        sb.append(AHTML.beginMultiColumnTable((int)97, (int)1));
        sb.append(AHTML.addHeaderRowMultiColumnTable(Arrays.asList("Team", "State", "Priority", "Change Type", "Assignee", "Title", "AI", "Created", "Targted Version", "Notes", "ID")));
        for (IAtsWorkItem workItem : workItems) {
            LinkedList<String> values = new LinkedList<String>();
            for (AtsColumnToken columnId : columns) {
                values.add(this.atsApiServer.getColumnService().getColumnText(columnId, (IAtsObject)workItem));
            }
            sb.append(AHTML.addRowMultiColumnTable((String[])values.toArray(new String[values.size()])));
        }
        sb.append(AHTML.endMultiColumnTable());
    }

    public ResultRows search(AtsSearchData atsSearchData) {
        AtsWorldResultRowOperation op = new AtsWorldResultRowOperation(this.atsApi, atsSearchData);
        ResultRows rows = op.run();
        return rows;
    }

    public ResultRows searchNew(AtsSearchData atsSearchData) {
        AtsWorldResultRowOperation op = new AtsWorldResultRowOperation(this.atsApi, atsSearchData);
        op.setNew(true);
        ResultRows rows = op.run();
        return rows;
    }
}

