/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.hooks;

import java.util.Collection;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinitionOption;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.core.internal.AtsApiService;

public class AtsForceAssigneesToTeamLeadsWorkItemHook
implements IAtsTransitionHook {
    public String getName() {
        return AtsForceAssigneesToTeamLeadsWorkItemHook.class.getSimpleName();
    }

    public String getDescription() {
        return "Check if toState is configured to force assignees to leads and set leads accordingly.";
    }

    public void transitioned(IAtsWorkItem workItem, IStateToken fromState, IStateToken toState, Collection<? extends AtsUser> toAssignees, AtsUser asUser, IAtsChangeSet changes) {
        Collection teamLeads;
        if (workItem instanceof IAtsTeamWorkflow && this.isForceAssigneesToTeamLeads(AtsApiService.get().getWorkDefinitionService().getStateDefinitionByName(workItem, toState.getName())) && !(teamLeads = AtsApiService.get().getTeamDefinitionService().getLeads(((IAtsTeamWorkflow)workItem).getTeamDefinition())).isEmpty()) {
            workItem.getStateMgr().setAssignees(teamLeads);
            changes.add((Object)workItem);
        }
    }

    private boolean isForceAssigneesToTeamLeads(StateDefinition stateDefinition) {
        return stateDefinition.hasRule(RuleDefinitionOption.ForceAssigneesToTeamLeads.name());
    }
}

