/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workdef.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.review.ReviewRole;
import org.eclipse.osee.ats.api.review.ReviewRoleType;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinitionBuilder;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.team.Priorities;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionToken;
import org.eclipse.osee.ats.api.workdef.StateToken;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workdef.model.CompositeLayoutItem;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefOption;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.core.workdef.builder.DecisionReviewDefinitionBuilder;
import org.eclipse.osee.ats.core.workdef.builder.HeaderDefinitionBuilder;
import org.eclipse.osee.ats.core.workdef.builder.PeerReviewDefinitionBuilder;
import org.eclipse.osee.ats.core.workdef.builder.StateDefBuilder;
import org.eclipse.osee.ats.core.workdef.builder.WorkDefBuilderOption;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.CountingMap;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class WorkDefBuilder {
    WorkDefinition workDef;
    XResultData rd;
    List<StateDefBuilder> stateDefBuilders = new ArrayList<StateDefBuilder>();

    public WorkDefBuilder(AtsWorkDefinitionToken workDefToken) {
        this(workDefToken, null);
    }

    public WorkDefBuilder(AtsWorkDefinitionToken workDefToken, ArtifactTypeToken artType) {
        this.workDef = new WorkDefinition(workDefToken.getId(), workDefToken.getName());
        this.workDef.setArtType(artType);
        this.rd = this.workDef.getResults();
    }

    public StateDefBuilder andState(int ordinal, StateToken state, StateType type, WorkDefBuilderOption ... builderOptions) {
        return this.andState(ordinal, state.getName(), type, builderOptions);
    }

    public StateDefBuilder andState(int ordinal, String name, StateType type, WorkDefBuilderOption ... builderOptions) {
        StateDefinition stateByName;
        if (ordinal <= 0) {
            this.rd.errorf("Ordinal must be > 1 for state [%s]\n", new Object[]{name});
        }
        if ((stateByName = this.workDef.getStateByName(name)) != null) {
            this.rd.errorf("State with name [%s] already exists\n", new Object[]{name});
        }
        for (StateDefinition state : this.workDef.getStates()) {
            if (state.getOrdinal() != ordinal) continue;
            this.rd.errorf("Ordinal [%s] already exists in state [%s]\n", new Object[]{ordinal, name});
        }
        StateDefBuilder stateDefBuilder = new StateDefBuilder(ordinal, name, type, this.workDef, builderOptions);
        this.stateDefBuilders.add(stateDefBuilder);
        return stateDefBuilder;
    }

    public WorkDefinition getWorkDefinition() {
        for (StateDefBuilder stateDefBuilder : this.stateDefBuilders) {
            StateToken defaultToStateToken = stateDefBuilder.getToDefaultStateToken();
            for (StateToken stateToken : stateDefBuilder.getToStateTokens()) {
                if (defaultToStateToken == StateToken.ANY) continue;
                StateDefinition toState = this.getStateDefinition(stateToken.getName());
                Conditions.assertNotNull((Object)toState, (String)String.format("toState [%s] can't be null in state [%s] and work def [%s]", stateToken, stateDefBuilder.getName(), this.workDef.getName()), (Object[])new Object[0]);
                stateDefBuilder.addToState(toState);
            }
        }
        for (StateDefBuilder stateDefBuilder : this.stateDefBuilders) {
            List<StateToken> states = stateDefBuilder.getToStateTokens();
            if (states.size() != 1 || states.iterator().next() != StateToken.ANY) continue;
            stateDefBuilder.state.getToStates().addAll(this.workDef.getStates());
            stateDefBuilder.state.getToStates().remove(stateDefBuilder.state);
        }
        CountingMap labelCount = this.workDef.getLabelCount();
        HashSet<String> headerLayoutItemNames = new HashSet<String>();
        this.allLayoutItemsToStringSet(headerLayoutItemNames, this.workDef.getHeaderDef().getLayoutItems());
        labelCount.put((Object)"Title");
        for (String label : headerLayoutItemNames) {
            labelCount.put((Object)label);
        }
        for (StateDefinition stateDefinition : this.workDef.getStates()) {
            HashSet<String> currStateLayoutItemNames = new HashSet<String>();
            this.allLayoutItemsToStringSet(currStateLayoutItemNames, stateDefinition.getLayoutItems());
            for (String label : currStateLayoutItemNames) {
                labelCount.put((Object)label);
            }
        }
        return this.workDef;
    }

    private void allLayoutItemsToStringSet(Set<String> ret, List<LayoutItem> inputList) {
        for (LayoutItem layItem : inputList) {
            if (layItem instanceof CompositeLayoutItem) {
                for (LayoutItem compItem : ((CompositeLayoutItem)layItem).getLayoutItems()) {
                    ret.add(compItem.getName());
                }
                continue;
            }
            ret.add(layItem.getName());
        }
    }

    private StateDefinition getStateDefinition(String name) {
        for (StateDefBuilder stateDefBldr : this.stateDefBuilders) {
            if (!stateDefBldr.state.getName().equals(name)) continue;
            return stateDefBldr.state;
        }
        return null;
    }

    public DecisionReviewDefinitionBuilder createDecisionReview(String name) {
        DecisionReviewDefinitionBuilder decRevBldr = new DecisionReviewDefinitionBuilder(name);
        return decRevBldr;
    }

    public PeerReviewDefinitionBuilder createPeerReview(String name) {
        PeerReviewDefinitionBuilder peerRevBldr = new PeerReviewDefinitionBuilder(name);
        return peerRevBldr;
    }

    public HeaderDefinitionBuilder andHeader() {
        HeaderDefinitionBuilder bldr = new HeaderDefinitionBuilder(this.workDef);
        this.workDef.setHeaderDefinition(bldr.getHeaderDefinition());
        return bldr;
    }

    public void isShowStateMetrics() {
        this.workDef.setShowStateMetrics(true);
    }

    public void isShowStateMetrics(boolean show) {
        this.workDef.setShowStateMetrics(show);
    }

    public CreateTasksDefinitionBuilder createTasksSetDefinitionBuilder(Long id, String name) {
        CreateTasksDefinitionBuilder taskSetDef = new CreateTasksDefinitionBuilder(id, name);
        return taskSetDef;
    }

    public void setReviewDefectColumns(XViewerColumn ... columns) {
        XViewerColumn[] xViewerColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            XViewerColumn col = xViewerColumnArray[n2];
            this.workDef.getReviewDefectColumns().add(col);
            ++n2;
        }
    }

    public StateDefBuilder getStateDefBuilder(StateToken state) {
        for (StateDefBuilder sBld : this.stateDefBuilders) {
            if (!sBld.getName().equals(state.getName())) continue;
            return sBld;
        }
        return null;
    }

    public WorkDefBuilder andReviewRole(ReviewRole role, int minimum) {
        this.workDef.addReviewRole(role, minimum);
        return this;
    }

    public WorkDefBuilder andWorkDefOption(WorkDefOption ... workDefOptions) {
        WorkDefOption[] workDefOptionArray = workDefOptions;
        int n = workDefOptions.length;
        int n2 = 0;
        while (n2 < n) {
            WorkDefOption opt = workDefOptionArray[n2];
            this.workDef.getOptions().add(opt);
            ++n2;
        }
        return this;
    }

    public WorkDefBuilder andReviewRole(ReviewRole role) {
        return this.andReviewRole(role, 0);
    }

    public WorkDefBuilder andReviewRoleTypeMinimum(ReviewRoleType reviewRoleType, int minimum) {
        this.workDef.andReviewRoleTypeMinimum(reviewRoleType, minimum);
        return this;
    }

    public WorkDefBuilder andArtType(ArtifactTypeToken artType) {
        this.workDef.setArtType(artType);
        return this;
    }

    public WorkDefBuilder andChangeTypes(ChangeTypes ... changeTypes) {
        ChangeTypes[] changeTypesArray = changeTypes;
        int n = changeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeTypes type = changeTypesArray[n2];
            this.workDef.getChangeTypes().add(type);
            ++n2;
        }
        return this;
    }

    public void andPointsAttributeType(AttributeTypeToken pointsAttrType) {
        this.workDef.setPointsAttrType(pointsAttrType);
    }

    public WorkDefBuilder andPriorities(Priorities ... priorities) {
        Priorities[] prioritiesArray = priorities;
        int n = priorities.length;
        int n2 = 0;
        while (n2 < n) {
            Priorities type = prioritiesArray[n2];
            this.workDef.getPriorities().add(type);
            ++n2;
        }
        return this;
    }

    public void andAssigneesRequired() {
        this.workDef.getOptions().add(WorkDefOption.RequireAssignees);
    }
}

