/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.rule.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.rule.validation.AbstractValidationRule;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public final class RelationSetRule
extends AbstractValidationRule {
    private final ArtifactTypeToken artifactType;
    private final Integer minimumRelations;
    private final RelationTypeSide relationEnum;
    private final Collection<ArtifactTypeToken> ignoreArtifactTypes;

    public RelationSetRule(ArtifactTypeToken artifactType, RelationTypeSide relationEnum, Integer minimumRelations, AtsApi atsApi, ArtifactTypeToken ... ignoreArtifactTypes) {
        super(atsApi);
        this.artifactType = artifactType;
        this.relationEnum = relationEnum;
        this.minimumRelations = minimumRelations;
        this.ignoreArtifactTypes = ignoreArtifactTypes.length == 0 ? new ArrayList() : Arrays.asList(ignoreArtifactTypes);
    }

    public boolean hasArtifactType(ArtifactTypeToken artifactTypeToValidate) {
        return artifactTypeToValidate.inheritsFrom((ArtifactTypeId)this.artifactType);
    }

    public void validate(ArtifactToken artifact, XResultData rd) {
        Collection arts;
        ArtifactTypeToken type = this.atsApi.getStoreService().getArtifactType((ArtifactId)artifact);
        if (this.atsApi.getStoreService().isHistorical((ArtifactId)artifact)) {
            return;
        }
        if (!this.isIgnoreType(type) && this.hasArtifactType(type) && (arts = this.atsApi.getRelationResolver().getRelatedArtifacts((ArtifactId)artifact, this.relationEnum)).size() < this.minimumRelations) {
            String errStr = "has less than minimum " + this.minimumRelations + " relation for type \"" + this.relationEnum.getName() + "\"";
            this.logError(artifact, errStr, rd);
        }
    }

    public String getRuleDescription() {
        return "For \"" + this.artifactType + "\", ensure at least " + this.minimumRelations + " relations(s) of type \"" + this.relationEnum + "\" exists";
    }

    public String getRuleTitle() {
        return "Relations Set Check:";
    }

    private Collection<ArtifactTypeToken> getIgnoreArtifactTypes() {
        return this.ignoreArtifactTypes;
    }

    private boolean isIgnoreType(ArtifactTypeToken type) {
        return this.getIgnoreArtifactTypes().contains(type);
    }
}

