/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.agile.IAgileProgramFeature;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.core.model.impl.AtsConfigObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.logger.Log;

public class AgileProgramFeature
extends AtsConfigObject
implements IAgileProgramFeature {
    public AgileProgramFeature(Log logger, AtsApi atsApi, ArtifactToken artifact) {
        super(logger, atsApi, artifact, AtsArtifactTypes.AgileProgramFeature);
    }

    public List<Long> getStoryIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ArtifactToken child : this.atsApi.getRelationResolver().getChildren((ArtifactId)this.artifact)) {
            if (!child.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileStory})) continue;
            ids.add(child.getId());
        }
        return ids;
    }

    public Long getProgramId() {
        return this.atsApi.getRelationResolver().getParent((ArtifactId)this.artifact).getId();
    }

    public static IAgileProgramFeature construct(ArtifactId progFeatureArt, AtsApi atsApi) {
        return new AgileProgramFeature(atsApi.getLogger(), atsApi, atsApi.getQueryService().getArtifact(progFeatureArt));
    }
}

