/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.filters.OAuthRequestFilter;
import org.apache.cxf.security.SecurityContext;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.internal.JaxRsResourceManager;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.OAuthUtil;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.SubjectProvider;
import org.eclipse.osee.logger.Log;

@PreMatching
public class OAuth2RequestFilter
extends OAuthRequestFilter {
    private final Log logger;
    private final JaxRsResourceManager resourceManager;
    private final SubjectProvider subjectProvider;
    private volatile boolean useUserSubject;
    private volatile URI redirectURI;
    private volatile URI redirectErrorURI;
    private volatile boolean ignoreBasePath;

    public OAuth2RequestFilter(Log logger, JaxRsResourceManager resourceManager, SubjectProvider subjectProvider) {
        this.logger = logger;
        this.resourceManager = resourceManager;
        this.subjectProvider = subjectProvider;
    }

    public void setUseUserSubject(boolean useUserSubject) {
        super.setUseUserSubject(useUserSubject);
        this.useUserSubject = useUserSubject;
    }

    public void setRedirectErrorURI(URI redirectErrorURI) {
        this.redirectErrorURI = redirectErrorURI;
    }

    public void setRedirectURI(URI redirectURI) {
        this.redirectURI = redirectURI;
    }

    public void setIgnoreBasePath(boolean ignoreBasePath) {
        this.ignoreBasePath = ignoreBasePath;
    }

    private boolean isPathSecure(ContainerRequestContext context) {
        boolean result = false;
        JaxRsResourceManager.Resource resource = this.resourceManager.findResource(context);
        result = resource != null ? resource.isSecure() : true;
        return result;
    }

    public void filter(ContainerRequestContext context) {
        boolean isSecurePath = this.isPathSecure(context);
        UriInfo uriInfo = context.getUriInfo();
        String path = Lib.getURIAbsolutePath((UriInfo)uriInfo);
        if (isSecurePath && path.contains("oauth2") || path.contains("accounts/self")) {
            if (this.isResourceOwnerRequest(context)) {
                this.handleResourceOwnerRequest(context);
            } else {
                super.filter(context);
            }
        }
    }

    private boolean isResourceOwnerRequest(ContainerRequestContext context) {
        String authorizationHeader = context.getHeaderString("Authorization");
        return !Strings.isValid((String)authorizationHeader) || this.isAuthenticationSchemeSupported(authorizationHeader);
    }

    private boolean isAuthenticationSchemeSupported(String header) {
        return header != null && header.startsWith("Basic");
    }

    private void handleResourceOwnerRequest(ContainerRequestContext context) {
        Message msg = JAXRSUtils.getCurrentMessage();
        MessageContext mc = this.getMessageContext();
        SecurityContext sc = this.subjectProvider.getSecurityContextFromSession(mc);
        if (sc == null) {
            String authorizationHeader = context.getHeaderString("Authorization");
            Response jaxRsResponse = null;
            if (this.isAuthenticationSchemeSupported(authorizationHeader)) {
                try {
                    this.doBasicAuthentication(mc, authorizationHeader);
                }
                catch (Exception ex) {
                    jaxRsResponse = this.getAuthenticationException(ex, msg, context);
                }
            } else {
                jaxRsResponse = this.getAuthorizationRequired(msg, context);
            }
            if (jaxRsResponse != null) {
                context.abortWith(jaxRsResponse);
            }
        }
    }

    private Response getAuthorizationRequired(Message msg, ContainerRequestContext context) {
        this.logger.debug("authorizationRequiredResponse called", new Object[0]);
        return OAuthUtil.newAuthorizationRequiredResponse(null, this.redirectURI, this.ignoreBasePath, this.realm, msg, context);
    }

    private Response getAuthenticationException(Exception ex, Message msg, ContainerRequestContext context) {
        this.logger.error((Throwable)ex, "Authorization error [%s]", new Object[]{msg.toString()});
        return OAuthUtil.newAuthorizationRequiredResponse(ex, this.redirectErrorURI, this.ignoreBasePath, this.realm, msg, context);
    }

    private void doBasicAuthentication(MessageContext mc, String header) {
        this.logger.debug("doBasicAuthentication called", new Object[0]);
        String[] basicAuthParts = OAuthUtil.decodeCredentials(header);
        String username = basicAuthParts[0];
        String password = basicAuthParts[1];
        this.subjectProvider.authenticate(mc, "Basic", username, password);
    }

    protected SecurityContext createSecurityContext(HttpServletRequest request, AccessTokenValidation accessTokenV) {
        return OAuthUtil.getSecurityContext(accessTokenV, this.useUserSubject);
    }
}

