/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.access.AccessTypeMatch;
import org.eclipse.osee.framework.core.access.context.AccessContext;
import org.eclipse.osee.framework.core.access.context.AccessType;
import org.eclipse.osee.framework.core.data.AccessContextToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class AccessContextResult {
    AccessContextToken contextId = null;
    AccessContext context = null;
    List<AccessType> accessTypes = new ArrayList<AccessType>();
    Map<AccessType, AccessTypeMatch> accessTypeToMatch = new HashMap<AccessType, AccessTypeMatch>();

    public AccessContextToken getContextId() {
        return this.contextId;
    }

    public void setContextId(AccessContextToken contextId) {
        this.contextId = contextId;
    }

    public AccessContext getContext() {
        return this.context;
    }

    public void setContext(AccessContext context) {
        this.context = context;
    }

    public void logToResults(XResultData results) {
        results.logf("%s\n", new Object[]{this.contextId.toStringWithId()});
        for (AccessType accessType : this.accessTypes) {
            results.logf("%s - %s\n", new Object[]{Lib.padTrailing((String)this.getAccessTypeMatchOrNotComputed(accessType).getName(), (char)' ', (int)7), accessType.toString()});
        }
    }

    private AccessTypeMatch getAccessTypeMatch(AccessType accessType) {
        return this.accessTypeToMatch.get(accessType);
    }

    private AccessTypeMatch getAccessTypeMatchOrNotComputed(AccessType accessType) {
        AccessTypeMatch match = this.getAccessTypeMatch(accessType);
        if (match == null) {
            match = AccessTypeMatch.NotComputed;
        }
        return match;
    }

    public List<AccessType> getAccessTypes() {
        return this.accessTypes;
    }

    public void setAccessTypes(List<AccessType> accessTypes) {
        this.accessTypes = accessTypes;
    }

    public void setAccessTypeMatch(AccessType accessType, AccessTypeMatch match) {
        this.accessTypeToMatch.put(accessType, match);
    }
}

