/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.resources;

import java.util.Collection;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.DispoSetData;
import org.eclipse.osee.disposition.model.DispoSetDescriptorData;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.resources.DispoItemResource;
import org.eclipse.osee.disposition.rest.resources.DispoSourceFileResource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.Id;

public class DispoSetResource {
    private final DispoApi dispoApi;
    private final BranchId branch;

    public DispoSetResource(DispoApi dispoApi, BranchId branch) {
        this.dispoApi = dispoApi;
        this.branch = branch;
    }

    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postDispoSet(DispoSetDescriptorData descriptor, @QueryParam(value="userName") String userName) {
        Response response;
        String name = descriptor.getName();
        String importPath = descriptor.getImportPath();
        String dispoType = descriptor.getDispoType();
        if (!(name.isEmpty() || importPath.isEmpty() || dispoType.isEmpty())) {
            boolean isUniqueSetName = this.dispoApi.isUniqueSetName(this.branch, name);
            if (isUniqueSetName) {
                ArtifactId createdSetId = this.dispoApi.createDispoSet(this.branch, descriptor, userName);
                DispoSet createdSet = this.dispoApi.getDispoSetById(this.branch, ArtifactId.valueOf((Id)createdSetId).getIdString());
                Response.Status status = Response.Status.CREATED;
                response = Response.status((Response.Status)status).entity((Object)createdSet).build();
            } else {
                Response.Status status = Response.Status.CONFLICT;
                response = Response.status((Response.Status)status).entity((Object)"Can't create sets with the same name").build();
            }
        } else {
            Response.Status status = Response.Status.BAD_REQUEST;
            response = Response.status((Response.Status)status).entity((Object)"The Set must have a name and import path").build();
        }
        return response;
    }

    @Path(value="{name}")
    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response postDispoSetByName(@FormParam(value="path") String importPath, @PathParam(value="name") String name, @QueryParam(value="dispoType") String dispoType, @QueryParam(value="userName") String userName) {
        DispoSetDescriptorData descriptor = new DispoSetDescriptorData();
        descriptor.setName(name);
        descriptor.setImportPath(importPath);
        descriptor.setDispoType(dispoType);
        return this.postDispoSet(descriptor, userName);
    }

    @Path(value="{setId}")
    @GET
    @Produces(value={"application/json"})
    public DispoSet getDispoSetById(@PathParam(value="setId") String setId) {
        return this.dispoApi.getDispoSetById(this.branch, setId);
    }

    @GET
    @Produces(value={"application/json"})
    public Iterable<DispoSet> getAllDispoSets(@QueryParam(value="type") String type) {
        List<DispoSet> allDispoSets = this.dispoApi.getDispoSets(this.branch, type);
        return allDispoSets;
    }

    @Path(value="toRerun")
    @GET
    @Produces(value={"application/json"})
    public List<String> getCheckedReruns(@QueryParam(value="name") String setName) {
        String setId = this.dispoApi.getDispoSetIdByName(this.branch, setName);
        if (setId == null) {
            return null;
        }
        List<String> reruns = this.dispoApi.getCheckedReruns(this.branch, setId);
        return reruns;
    }

    @Path(value="getDispoSetId")
    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public String getDispoSetId(@FormParam(value="name") String setName) {
        return this.dispoApi.getDispoSetIdByName(this.branch, setName);
    }

    @Path(value="importDispoSet")
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response putDispoSetByName(@FormParam(value="name") String setName) {
        DispoSetData newDispositionSet = new DispoSetData();
        newDispositionSet.setOperation("Import");
        String setId = this.dispoApi.getDispoSetIdByName(this.branch, setName);
        if (setId != null) {
            this.dispoApi.editDispoSet(this.branch, setId, newDispositionSet, "OSEE System Auto-Import (Set)");
        }
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="{setId}")
    @PUT
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    public Response putDispoSet(@PathParam(value="setId") String setId, DispoSetData newDispositionSet, @QueryParam(value="userName") String userName) {
        this.dispoApi.editDispoSet(this.branch, setId, newDispositionSet, userName);
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="{setId}/massDisposition")
    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    public Response runMassDisposition(@PathParam(value="setId") String setId, @QueryParam(value="resolutionType") String resolutionType, @QueryParam(value="resolution") String resolution, List<String> itemIds, @QueryParam(value="userName") String userName) {
        this.dispoApi.editMassDispositions(this.branch, setId, itemIds, resolutionType, resolution, userName);
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="{setId}")
    @RolesAllowed(value={"dispoAdmin"})
    @DELETE
    public Response deleteDispoSet(@PathParam(value="setId") String setId, @QueryParam(value="userName") String userName) {
        Response.Status status = Response.Status.NOT_FOUND;
        boolean wasDeleted = this.dispoApi.deleteDispoSet(this.branch, setId, userName);
        status = wasDeleted ? Response.Status.OK : Response.Status.NOT_FOUND;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="{setId}/file")
    public DispoSourceFileResource getDispoSourceFiles(@PathParam(value="setId") String setId) {
        return new DispoSourceFileResource(this.dispoApi, this.branch, setId);
    }

    @Path(value="{setId}/item")
    public DispoItemResource getDispositionableItems(@PathParam(value="setId") String setId) {
        return new DispoItemResource(this.dispoApi, this.branch, setId);
    }

    @Path(value="{setId}/search")
    @GET
    @Produces(value={"application/json"})
    public Iterable<DispoItem> getDispoItemsByAnnotationText(@PathParam(value="setId") String setId, @QueryParam(value="value") String value, @QueryParam(value="isDetailed") boolean isDetailed) {
        Collection<DispoItem> foundItems = this.dispoApi.getDispoItemByAnnotationText(this.branch, setId, value, isDetailed);
        return foundItems;
    }
}

