/**
 * Copyright (c) 2013 itemis AG and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Mark Broerkens - initial API and implementation
 * 
 */
package org.eclipse.rmf.reqif10.datatypes.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.rmf.reqif10.datatypes.DatatypesFactory;
import org.eclipse.rmf.reqif10.datatypes.DatatypesPackage;
import org.eclipse.rmf.reqif10.datatypes.FrameTargetMember0;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!-- end-user-doc -->
 * 
 * @generated
 */
public class DatatypesFactoryImpl extends EFactoryImpl implements DatatypesFactory {
	/**
	 * Creates the default factory implementation. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public static DatatypesFactory init() {
		try {
			DatatypesFactory theDatatypesFactory = (DatatypesFactory) EPackage.Registry.INSTANCE.getEFactory(DatatypesPackage.eNS_URI);
			if (theDatatypesFactory != null) {
				return theDatatypesFactory;
			}
		} catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new DatatypesFactoryImpl();
	}

	/**
	 * Creates an instance of the factory. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public DatatypesFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
		default:
			throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
		case DatatypesPackage.FRAME_TARGET_MEMBER0:
			return createFrameTargetMember0FromString(eDataType, initialValue);
		case DatatypesPackage.CDATA:
			return createCDATAFromString(eDataType, initialValue);
		case DatatypesPackage.CHARACTER:
			return createCharacterFromString(eDataType, initialValue);
		case DatatypesPackage.CHARSET:
			return createCharsetFromString(eDataType, initialValue);
		case DatatypesPackage.CHARSETS:
			return createCharsetsFromString(eDataType, initialValue);
		case DatatypesPackage.COLOR:
			return createColorFromString(eDataType, initialValue);
		case DatatypesPackage.COLOR_MEMBER1:
			return createColorMember1FromString(eDataType, initialValue);
		case DatatypesPackage.CONTENT_TYPE:
			return createContentTypeFromString(eDataType, initialValue);
		case DatatypesPackage.CONTENT_TYPES:
			return createContentTypesFromString(eDataType, initialValue);
		case DatatypesPackage.CURIE:
			return createCURIEFromString(eDataType, initialValue);
		case DatatypesPackage.CURI_ES:
			return createCURIEsFromString(eDataType, initialValue);
		case DatatypesPackage.DATETIME:
			return createDatetimeFromString(eDataType, initialValue);
		case DatatypesPackage.FPI:
			return createFPIFromString(eDataType, initialValue);
		case DatatypesPackage.FRAME_TARGET:
			return createFrameTargetFromString(eDataType, initialValue);
		case DatatypesPackage.FRAME_TARGET_MEMBER0_OBJECT:
			return createFrameTargetMember0ObjectFromString(eDataType, initialValue);
		case DatatypesPackage.FRAME_TARGET_MEMBER1:
			return createFrameTargetMember1FromString(eDataType, initialValue);
		case DatatypesPackage.LANGUAGE_CODE:
			return createLanguageCodeFromString(eDataType, initialValue);
		case DatatypesPackage.LANGUAGE_CODES:
			return createLanguageCodesFromString(eDataType, initialValue);
		case DatatypesPackage.LENGTH:
			return createLengthFromString(eDataType, initialValue);
		case DatatypesPackage.LENGTH_MEMBER1:
			return createLengthMember1FromString(eDataType, initialValue);
		case DatatypesPackage.LINK_TYPES:
			return createLinkTypesFromString(eDataType, initialValue);
		case DatatypesPackage.MEDIA_DESC:
			return createMediaDescFromString(eDataType, initialValue);
		case DatatypesPackage.MULTI_LENGTH:
			return createMultiLengthFromString(eDataType, initialValue);
		case DatatypesPackage.MULTI_LENGTH_MEMBER1:
			return createMultiLengthMember1FromString(eDataType, initialValue);
		case DatatypesPackage.MULTI_LENGTHS:
			return createMultiLengthsFromString(eDataType, initialValue);
		case DatatypesPackage.NUMBER:
			return createNumberFromString(eDataType, initialValue);
		case DatatypesPackage.PIXELS:
			return createPixelsFromString(eDataType, initialValue);
		case DatatypesPackage.SAFE_CURIE:
			return createSafeCURIEFromString(eDataType, initialValue);
		case DatatypesPackage.SAFE_CURI_ES:
			return createSafeCURIEsFromString(eDataType, initialValue);
		case DatatypesPackage.SCRIPT:
			return createScriptFromString(eDataType, initialValue);
		case DatatypesPackage.TEXT:
			return createTextFromString(eDataType, initialValue);
		case DatatypesPackage.URI:
			return createURIFromString(eDataType, initialValue);
		case DatatypesPackage.UR_IOR_SAFE_CURIE:
			return createURIorSafeCURIEFromString(eDataType, initialValue);
		case DatatypesPackage.UR_IOR_SAFE_CURI_ES:
			return createURIorSafeCURIEsFromString(eDataType, initialValue);
		case DatatypesPackage.URIREF:
			return createURIREFFromString(eDataType, initialValue);
		case DatatypesPackage.UR_IS:
			return createURIsFromString(eDataType, initialValue);
		default:
			throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
		case DatatypesPackage.FRAME_TARGET_MEMBER0:
			return convertFrameTargetMember0ToString(eDataType, instanceValue);
		case DatatypesPackage.CDATA:
			return convertCDATAToString(eDataType, instanceValue);
		case DatatypesPackage.CHARACTER:
			return convertCharacterToString(eDataType, instanceValue);
		case DatatypesPackage.CHARSET:
			return convertCharsetToString(eDataType, instanceValue);
		case DatatypesPackage.CHARSETS:
			return convertCharsetsToString(eDataType, instanceValue);
		case DatatypesPackage.COLOR:
			return convertColorToString(eDataType, instanceValue);
		case DatatypesPackage.COLOR_MEMBER1:
			return convertColorMember1ToString(eDataType, instanceValue);
		case DatatypesPackage.CONTENT_TYPE:
			return convertContentTypeToString(eDataType, instanceValue);
		case DatatypesPackage.CONTENT_TYPES:
			return convertContentTypesToString(eDataType, instanceValue);
		case DatatypesPackage.CURIE:
			return convertCURIEToString(eDataType, instanceValue);
		case DatatypesPackage.CURI_ES:
			return convertCURIEsToString(eDataType, instanceValue);
		case DatatypesPackage.DATETIME:
			return convertDatetimeToString(eDataType, instanceValue);
		case DatatypesPackage.FPI:
			return convertFPIToString(eDataType, instanceValue);
		case DatatypesPackage.FRAME_TARGET:
			return convertFrameTargetToString(eDataType, instanceValue);
		case DatatypesPackage.FRAME_TARGET_MEMBER0_OBJECT:
			return convertFrameTargetMember0ObjectToString(eDataType, instanceValue);
		case DatatypesPackage.FRAME_TARGET_MEMBER1:
			return convertFrameTargetMember1ToString(eDataType, instanceValue);
		case DatatypesPackage.LANGUAGE_CODE:
			return convertLanguageCodeToString(eDataType, instanceValue);
		case DatatypesPackage.LANGUAGE_CODES:
			return convertLanguageCodesToString(eDataType, instanceValue);
		case DatatypesPackage.LENGTH:
			return convertLengthToString(eDataType, instanceValue);
		case DatatypesPackage.LENGTH_MEMBER1:
			return convertLengthMember1ToString(eDataType, instanceValue);
		case DatatypesPackage.LINK_TYPES:
			return convertLinkTypesToString(eDataType, instanceValue);
		case DatatypesPackage.MEDIA_DESC:
			return convertMediaDescToString(eDataType, instanceValue);
		case DatatypesPackage.MULTI_LENGTH:
			return convertMultiLengthToString(eDataType, instanceValue);
		case DatatypesPackage.MULTI_LENGTH_MEMBER1:
			return convertMultiLengthMember1ToString(eDataType, instanceValue);
		case DatatypesPackage.MULTI_LENGTHS:
			return convertMultiLengthsToString(eDataType, instanceValue);
		case DatatypesPackage.NUMBER:
			return convertNumberToString(eDataType, instanceValue);
		case DatatypesPackage.PIXELS:
			return convertPixelsToString(eDataType, instanceValue);
		case DatatypesPackage.SAFE_CURIE:
			return convertSafeCURIEToString(eDataType, instanceValue);
		case DatatypesPackage.SAFE_CURI_ES:
			return convertSafeCURIEsToString(eDataType, instanceValue);
		case DatatypesPackage.SCRIPT:
			return convertScriptToString(eDataType, instanceValue);
		case DatatypesPackage.TEXT:
			return convertTextToString(eDataType, instanceValue);
		case DatatypesPackage.URI:
			return convertURIToString(eDataType, instanceValue);
		case DatatypesPackage.UR_IOR_SAFE_CURIE:
			return convertURIorSafeCURIEToString(eDataType, instanceValue);
		case DatatypesPackage.UR_IOR_SAFE_CURI_ES:
			return convertURIorSafeCURIEsToString(eDataType, instanceValue);
		case DatatypesPackage.URIREF:
			return convertURIREFToString(eDataType, instanceValue);
		case DatatypesPackage.UR_IS:
			return convertURIsToString(eDataType, instanceValue);
		default:
			throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public FrameTargetMember0 createFrameTargetMember0FromString(EDataType eDataType, String initialValue) {
		FrameTargetMember0 result = FrameTargetMember0.get(initialValue);
		if (result == null) {
			throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertFrameTargetMember0ToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createCDATAFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertCDATAToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createCharacterFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertCharacterToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createCharsetFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertCharsetToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public List<String> createCharsetsFromString(EDataType eDataType, String initialValue) {
		if (initialValue == null) {
			return null;
		}
		List<String> result = new ArrayList<String>();
		for (String item : split(initialValue)) {
			result.add(createCharsetFromString(DatatypesPackage.Literals.CHARSET, item));
		}
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertCharsetsToString(EDataType eDataType, Object instanceValue) {
		if (instanceValue == null) {
			return null;
		}
		List<?> list = (List<?>) instanceValue;
		if (list.isEmpty()) {
			return ""; //$NON-NLS-1$
		}
		StringBuffer result = new StringBuffer();
		for (Object item : list) {
			result.append(convertCharsetToString(DatatypesPackage.Literals.CHARSET, item));
			result.append(' ');
		}
		return result.substring(0, result.length() - 1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createColorFromString(EDataType eDataType, String initialValue) {
		if (initialValue == null) {
			return null;
		}
		String result = null;
		RuntimeException exception = null;
		try {
			result = (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.NMTOKEN, initialValue);
			if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
				return result;
			}
		} catch (RuntimeException e) {
			exception = e;
		}
		try {
			result = createColorMember1FromString(DatatypesPackage.Literals.COLOR_MEMBER1, initialValue);
			if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
				return result;
			}
		} catch (RuntimeException e) {
			exception = e;
		}
		if (result != null || exception == null) {
			return result;
		}

		throw exception;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertColorToString(EDataType eDataType, Object instanceValue) {
		if (instanceValue == null) {
			return null;
		}
		if (XMLTypePackage.Literals.NMTOKEN.isInstance(instanceValue)) {
			try {
				String value = XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.NMTOKEN, instanceValue);
				if (value != null) {
					return value;
				}
			} catch (Exception e) {
				// Keep trying other member types until all have failed.
			}
		}
		if (DatatypesPackage.Literals.COLOR_MEMBER1.isInstance(instanceValue)) {
			try {
				String value = convertColorMember1ToString(DatatypesPackage.Literals.COLOR_MEMBER1, instanceValue);
				if (value != null) {
					return value;
				}
			} catch (Exception e) {
				// Keep trying other member types until all have failed.
			}
		}
		throw new IllegalArgumentException("Invalid value: '" + instanceValue + "' for datatype :" + eDataType.getName()); //$NON-NLS-1$//$NON-NLS-2$
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createColorMember1FromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.TOKEN, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertColorMember1ToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.TOKEN, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createContentTypeFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertContentTypeToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createContentTypesFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertContentTypesToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createCURIEFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertCURIEToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public List<String> createCURIEsFromString(EDataType eDataType, String initialValue) {
		if (initialValue == null) {
			return null;
		}
		List<String> result = new ArrayList<String>();
		for (String item : split(initialValue)) {
			result.add(createCURIEFromString(DatatypesPackage.Literals.CURIE, item));
		}
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertCURIEsToString(EDataType eDataType, Object instanceValue) {
		if (instanceValue == null) {
			return null;
		}
		List<?> list = (List<?>) instanceValue;
		if (list.isEmpty()) {
			return ""; //$NON-NLS-1$
		}
		StringBuffer result = new StringBuffer();
		for (Object item : list) {
			result.append(convertCURIEToString(DatatypesPackage.Literals.CURIE, item));
			result.append(' ');
		}
		return result.substring(0, result.length() - 1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public XMLGregorianCalendar createDatetimeFromString(EDataType eDataType, String initialValue) {
		return (XMLGregorianCalendar) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.DATE_TIME, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertDatetimeToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.DATE_TIME, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createFPIFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.NORMALIZED_STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertFPIToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.NORMALIZED_STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Object createFrameTargetFromString(EDataType eDataType, String initialValue) {
		if (initialValue == null) {
			return null;
		}
		Object result = null;
		RuntimeException exception = null;
		try {
			result = createFrameTargetMember0FromString(DatatypesPackage.Literals.FRAME_TARGET_MEMBER0, initialValue);
			if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
				return result;
			}
		} catch (RuntimeException e) {
			exception = e;
		}
		try {
			result = createFrameTargetMember1FromString(DatatypesPackage.Literals.FRAME_TARGET_MEMBER1, initialValue);
			if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
				return result;
			}
		} catch (RuntimeException e) {
			exception = e;
		}
		if (result != null || exception == null) {
			return result;
		}

		throw exception;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertFrameTargetToString(EDataType eDataType, Object instanceValue) {
		if (instanceValue == null) {
			return null;
		}
		if (DatatypesPackage.Literals.FRAME_TARGET_MEMBER0.isInstance(instanceValue)) {
			try {
				String value = convertFrameTargetMember0ToString(DatatypesPackage.Literals.FRAME_TARGET_MEMBER0, instanceValue);
				if (value != null) {
					return value;
				}
			} catch (Exception e) {
				// Keep trying other member types until all have failed.
			}
		}
		if (DatatypesPackage.Literals.FRAME_TARGET_MEMBER1.isInstance(instanceValue)) {
			try {
				String value = convertFrameTargetMember1ToString(DatatypesPackage.Literals.FRAME_TARGET_MEMBER1, instanceValue);
				if (value != null) {
					return value;
				}
			} catch (Exception e) {
				// Keep trying other member types until all have failed.
			}
		}
		throw new IllegalArgumentException("Invalid value: '" + instanceValue + "' for datatype :" + eDataType.getName()); //$NON-NLS-1$//$NON-NLS-2$
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public FrameTargetMember0 createFrameTargetMember0ObjectFromString(EDataType eDataType, String initialValue) {
		return createFrameTargetMember0FromString(DatatypesPackage.Literals.FRAME_TARGET_MEMBER0, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertFrameTargetMember0ObjectToString(EDataType eDataType, Object instanceValue) {
		return convertFrameTargetMember0ToString(DatatypesPackage.Literals.FRAME_TARGET_MEMBER0, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createFrameTargetMember1FromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertFrameTargetMember1ToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createLanguageCodeFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.LANGUAGE, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertLanguageCodeToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.LANGUAGE, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createLanguageCodesFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertLanguageCodesToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Object createLengthFromString(EDataType eDataType, String initialValue) {
		if (initialValue == null) {
			return null;
		}
		Object result = null;
		RuntimeException exception = null;
		try {
			result = XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.NON_NEGATIVE_INTEGER, initialValue);
			if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
				return result;
			}
		} catch (RuntimeException e) {
			exception = e;
		}
		try {
			result = createLengthMember1FromString(DatatypesPackage.Literals.LENGTH_MEMBER1, initialValue);
			if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
				return result;
			}
		} catch (RuntimeException e) {
			exception = e;
		}
		if (result != null || exception == null) {
			return result;
		}

		throw exception;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertLengthToString(EDataType eDataType, Object instanceValue) {
		if (instanceValue == null) {
			return null;
		}
		if (XMLTypePackage.Literals.NON_NEGATIVE_INTEGER.isInstance(instanceValue)) {
			try {
				String value = XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.NON_NEGATIVE_INTEGER, instanceValue);
				if (value != null) {
					return value;
				}
			} catch (Exception e) {
				// Keep trying other member types until all have failed.
			}
		}
		if (DatatypesPackage.Literals.LENGTH_MEMBER1.isInstance(instanceValue)) {
			try {
				String value = convertLengthMember1ToString(DatatypesPackage.Literals.LENGTH_MEMBER1, instanceValue);
				if (value != null) {
					return value;
				}
			} catch (Exception e) {
				// Keep trying other member types until all have failed.
			}
		}
		throw new IllegalArgumentException("Invalid value: '" + instanceValue + "' for datatype :" + eDataType.getName()); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createLengthMember1FromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.TOKEN, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertLengthMember1ToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.TOKEN, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public List<String> createLinkTypesFromString(EDataType eDataType, String initialValue) {
		if (initialValue == null) {
			return null;
		}
		List<String> result = new ArrayList<String>();
		for (String item : split(initialValue)) {
			result.add((String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.NMTOKEN, item));
		}
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertLinkTypesToString(EDataType eDataType, Object instanceValue) {
		if (instanceValue == null) {
			return null;
		}
		List<?> list = (List<?>) instanceValue;
		if (list.isEmpty()) {
			return ""; //$NON-NLS-1$
		}
		StringBuffer result = new StringBuffer();
		for (Object item : list) {
			result.append(XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.NMTOKEN, item));
			result.append(' ');
		}
		return result.substring(0, result.length() - 1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createMediaDescFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertMediaDescToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Object createMultiLengthFromString(EDataType eDataType, String initialValue) {
		if (initialValue == null) {
			return null;
		}
		Object result = null;
		RuntimeException exception = null;
		try {
			result = createLengthFromString(DatatypesPackage.Literals.LENGTH, initialValue);
			if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
				return result;
			}
		} catch (RuntimeException e) {
			exception = e;
		}
		try {
			result = createMultiLengthMember1FromString(DatatypesPackage.Literals.MULTI_LENGTH_MEMBER1, initialValue);
			if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
				return result;
			}
		} catch (RuntimeException e) {
			exception = e;
		}
		if (result != null || exception == null) {
			return result;
		}

		throw exception;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertMultiLengthToString(EDataType eDataType, Object instanceValue) {
		if (instanceValue == null) {
			return null;
		}
		if (DatatypesPackage.Literals.LENGTH.isInstance(instanceValue)) {
			try {
				String value = convertLengthToString(DatatypesPackage.Literals.LENGTH, instanceValue);
				if (value != null) {
					return value;
				}
			} catch (Exception e) {
				// Keep trying other member types until all have failed.
			}
		}
		if (DatatypesPackage.Literals.MULTI_LENGTH_MEMBER1.isInstance(instanceValue)) {
			try {
				String value = convertMultiLengthMember1ToString(DatatypesPackage.Literals.MULTI_LENGTH_MEMBER1, instanceValue);
				if (value != null) {
					return value;
				}
			} catch (Exception e) {
				// Keep trying other member types until all have failed.
			}
		}
		throw new IllegalArgumentException("Invalid value: '" + instanceValue + "' for datatype :" + eDataType.getName()); //$NON-NLS-1$ //$NON-NLS-2$
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createMultiLengthMember1FromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.TOKEN, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertMultiLengthMember1ToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.TOKEN, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createMultiLengthsFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertMultiLengthsToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public BigInteger createNumberFromString(EDataType eDataType, String initialValue) {
		return (BigInteger) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.NON_NEGATIVE_INTEGER, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertNumberToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.NON_NEGATIVE_INTEGER, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public BigInteger createPixelsFromString(EDataType eDataType, String initialValue) {
		return (BigInteger) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.NON_NEGATIVE_INTEGER, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertPixelsToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.NON_NEGATIVE_INTEGER, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createSafeCURIEFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertSafeCURIEToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public List<String> createSafeCURIEsFromString(EDataType eDataType, String initialValue) {
		if (initialValue == null) {
			return null;
		}
		List<String> result = new ArrayList<String>();
		for (String item : split(initialValue)) {
			result.add(createSafeCURIEFromString(DatatypesPackage.Literals.SAFE_CURIE, item));
		}
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertSafeCURIEsToString(EDataType eDataType, Object instanceValue) {
		if (instanceValue == null) {
			return null;
		}
		List<?> list = (List<?>) instanceValue;
		if (list.isEmpty()) {
			return ""; //$NON-NLS-1$
		}
		StringBuffer result = new StringBuffer();
		for (Object item : list) {
			result.append(convertSafeCURIEToString(DatatypesPackage.Literals.SAFE_CURIE, item));
			result.append(' ');
		}
		return result.substring(0, result.length() - 1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createScriptFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertScriptToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createTextFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertTextToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createURIFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.ANY_URI, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertURIToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.ANY_URI, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createURIorSafeCURIEFromString(EDataType eDataType, String initialValue) {
		if (initialValue == null) {
			return null;
		}
		String result = null;
		RuntimeException exception = null;
		try {
			result = (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.ANY_URI, initialValue);
			if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
				return result;
			}
		} catch (RuntimeException e) {
			exception = e;
		}
		try {
			result = createSafeCURIEFromString(DatatypesPackage.Literals.SAFE_CURIE, initialValue);
			if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
				return result;
			}
		} catch (RuntimeException e) {
			exception = e;
		}
		if (result != null || exception == null) {
			return result;
		}

		throw exception;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertURIorSafeCURIEToString(EDataType eDataType, Object instanceValue) {
		if (instanceValue == null) {
			return null;
		}
		if (XMLTypePackage.Literals.ANY_URI.isInstance(instanceValue)) {
			try {
				String value = XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.ANY_URI, instanceValue);
				if (value != null) {
					return value;
				}
			} catch (Exception e) {
				// Keep trying other member types until all have failed.
			}
		}
		if (DatatypesPackage.Literals.SAFE_CURIE.isInstance(instanceValue)) {
			try {
				String value = convertSafeCURIEToString(DatatypesPackage.Literals.SAFE_CURIE, instanceValue);
				if (value != null) {
					return value;
				}
			} catch (Exception e) {
				// Keep trying other member types until all have failed.
			}
		}
		throw new IllegalArgumentException("Invalid value: '" + instanceValue + "' for datatype :" + eDataType.getName()); //$NON-NLS-1$//$NON-NLS-2$
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public List<String> createURIorSafeCURIEsFromString(EDataType eDataType, String initialValue) {
		if (initialValue == null) {
			return null;
		}
		List<String> result = new ArrayList<String>();
		for (String item : split(initialValue)) {
			result.add(createURIorSafeCURIEFromString(DatatypesPackage.Literals.UR_IOR_SAFE_CURIE, item));
		}
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertURIorSafeCURIEsToString(EDataType eDataType, Object instanceValue) {
		if (instanceValue == null) {
			return null;
		}
		List<?> list = (List<?>) instanceValue;
		if (list.isEmpty()) {
			return ""; //$NON-NLS-1$
		}
		StringBuffer result = new StringBuffer();
		for (Object item : list) {
			result.append(convertURIorSafeCURIEToString(DatatypesPackage.Literals.UR_IOR_SAFE_CURIE, item));
			result.append(' ');
		}
		return result.substring(0, result.length() - 1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String createURIREFFromString(EDataType eDataType, String initialValue) {
		return (String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertURIREFToString(EDataType eDataType, Object instanceValue) {
		return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public List<String> createURIsFromString(EDataType eDataType, String initialValue) {
		if (initialValue == null) {
			return null;
		}
		List<String> result = new ArrayList<String>();
		for (String item : split(initialValue)) {
			result.add((String) XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.ANY_URI, item));
		}
		return result;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String convertURIsToString(EDataType eDataType, Object instanceValue) {
		if (instanceValue == null) {
			return null;
		}
		List<?> list = (List<?>) instanceValue;
		if (list.isEmpty()) {
			return ""; //$NON-NLS-1$
		}
		StringBuffer result = new StringBuffer();
		for (Object item : list) {
			result.append(XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.ANY_URI, item));
			result.append(' ');
		}
		return result.substring(0, result.length() - 1);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public DatatypesPackage getDatatypesPackage() {
		return (DatatypesPackage) getEPackage();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static DatatypesPackage getPackage() {
		return DatatypesPackage.eINSTANCE;
	}

} // DatatypesFactoryImpl
