/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal;

import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsAdmin;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.account.admin.internal.AccountFactory;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public abstract class AbstractOrcsStorage {
    private Log logger;
    private OrcsApi orcsApi;
    private AccountFactory factory;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void setAccountFactory(AccountFactory factory) {
        this.factory = factory;
    }

    public void start() {
        this.logger.trace("Starting [%s]...", new Object[]{this.getClass().getSimpleName()});
    }

    public void stop() {
        this.logger.trace("Stopping [%s]...", new Object[]{this.getClass().getSimpleName()});
    }

    protected Log getLogger() {
        return this.logger;
    }

    protected AccountFactory getFactory() {
        return this.factory;
    }

    protected QueryBuilder newQuery() {
        QueryFactory queryFactory = this.orcsApi.getQueryFactory();
        return queryFactory.fromBranch((BranchId)CoreBranches.COMMON);
    }

    protected TransactionBuilder newTransaction(String comment) {
        TransactionFactory transactionFactory = this.orcsApi.getTransactionFactory();
        return transactionFactory.createTransaction((BranchId)CoreBranches.COMMON, comment);
    }

    protected boolean isInitialized() {
        OrcsAdmin adminOps = this.orcsApi.getAdminOps();
        return adminOps.isDataStoreInitialized();
    }
}

