/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.indexer.callable.producer;

import java.util.Collection;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreCallable;
import org.eclipse.osee.orcs.db.internal.search.indexer.IndexingTaskConsumer;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.TagQueueJoinQuery;
import org.eclipse.osee.orcs.search.IndexerCollector;

public final class IndexAllInQueueCallable
extends AbstractDatastoreCallable<Integer> {
    private final SqlJoinFactory joinFactory;
    private final IndexingTaskConsumer consumer;
    private final IndexerCollector collector;
    private final OrcsTokenService tokenService;
    private Collection<Long> queryIds;

    public IndexAllInQueueCallable(Log logger, OrcsSession session, JdbcClient service, SqlJoinFactory joinFactory, OrcsTokenService tokenService, IndexingTaskConsumer consumer, IndexerCollector collector) {
        super(logger, session, service);
        this.consumer = consumer;
        this.collector = collector;
        this.joinFactory = joinFactory;
        this.tokenService = tokenService;
    }

    public Integer call() throws Exception {
        TagQueueJoinQuery joinQuery = this.joinFactory.createTagQueueJoinQuery();
        this.queryIds = joinQuery.getAllQueryIds();
        this.getLogger().info("Submitting - [%d] index tasks from queue", new Object[]{this.queryIds.size()});
        for (Long queryId : this.queryIds) {
            this.consumer.submitTaskId(this.getSession(), this.tokenService, this.collector, queryId);
        }
        return this.queryIds.size();
    }

    @Override
    public void setCancel(boolean isCancelled) {
        super.setCancel(isCancelled);
        if (this.isCancelled() && this.queryIds != null && !this.queryIds.isEmpty()) {
            this.consumer.cancelTaskId(this.queryIds);
            this.queryIds = null;
        }
    }
}

