/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.exchange.TranslationManager;
import org.eclipse.osee.orcs.db.internal.exchange.handler.BaseExportImportSaxHandler;
import org.eclipse.osee.orcs.db.internal.exchange.handler.MetaData;

public abstract class BaseDbSaxHandler
extends BaseExportImportSaxHandler {
    private final List<Object[]> data;
    private final int cacheLimit;
    private final boolean isCacheAll;
    private MetaData metadata;
    private TranslationManager translator;
    private PropertyStore options;
    private final JdbcClient service;
    private final Log logger;

    protected BaseDbSaxHandler(Log logger, JdbcClient service, boolean isCacheAll, int cacheLimit) {
        if (cacheLimit < 0) {
            throw new IllegalArgumentException(String.format("Cache limit cannot be less than zero - cacheLimit=[%d]", cacheLimit));
        }
        this.logger = logger;
        this.service = service;
        this.options = new PropertyStore();
        this.translator = null;
        this.metadata = null;
        this.isCacheAll = isCacheAll;
        this.cacheLimit = cacheLimit;
        this.data = new ArrayList<Object[]>();
    }

    protected Log getLogger() {
        return this.logger;
    }

    public void setOptions(PropertyStore options) {
        if (options != null) {
            this.options = options;
        }
    }

    protected PropertyStore getOptions() {
        return this.options;
    }

    public void setMetaData(MetaData metadata) {
        this.metadata = metadata;
    }

    public void setTranslator(TranslationManager translator) {
        this.translator = translator;
    }

    protected MetaData getMetaData() {
        return this.metadata;
    }

    protected TranslationManager getTranslator() {
        return this.translator;
    }

    public boolean isStorageNeeded() {
        return !this.isCacheAll && this.data.size() > this.cacheLimit;
    }

    protected void addData(Object[] objects) {
        this.data.add(objects);
    }

    public void store() {
        this.store(null);
    }

    public void store(JdbcConnection connection) {
        if (!this.data.isEmpty()) {
            this.getDatabaseService().runBatchUpdate(connection, this.getMetaData().getQuery(), this.data);
            this.data.clear();
        }
    }

    public void clearDataTable() {
        this.service.clearTable(this.getMetaData().getTableName());
    }

    protected JdbcClient getDatabaseService() {
        return this.service;
    }

    public void reset() {
        this.translator = null;
        this.options = null;
        this.metadata = null;
        this.data.clear();
    }
}

