/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface Named
extends Comparable<Named> {
    public static final String SENTINEL = "Sentinel";

    default public String getName() {
        return this.toString();
    }

    @Override
    default public int compareTo(Named other) {
        if (other != null && other.getName() != null && this.getName() != null) {
            return this.getName().compareTo(other.getName());
        }
        return -1;
    }

    public static List<String> getNames(Collection<? extends Named> namedObjects) {
        return namedObjects.stream().map(Named::getName).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T extends Named> List<String> getNames(Collection<T> namedObjects, Predicate<T> predicate) {
        return namedObjects.stream().filter(predicate).map(Named::getName).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<String> getNames(Named ... namedObjects) {
        return Named.getNames(Arrays.asList(namedObjects));
    }

    public static String[] getNamesArray(Named ... namedObjects) {
        String[] names = new String[namedObjects.length];
        int i = 0;
        while (i < names.length) {
            names[i] = namedObjects[i].getName();
            ++i;
        }
        return names;
    }

    public static String[] getNamesArray(Collection<? extends Named> namedObjects) {
        String[] names = new String[namedObjects.size()];
        int i = 0;
        for (Named named : namedObjects) {
            names[i++] = named.getName();
        }
        return names;
    }
}

