/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.graph;

import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.internal.artifact.ArtifactFactory;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeFactory;
import org.eclipse.osee.orcs.core.internal.graph.GraphBuilder;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.graph.GraphProvider;
import org.eclipse.osee.orcs.core.internal.graph.GraphUtil;
import org.eclipse.osee.orcs.core.internal.graph.impl.GraphBuilderImpl;
import org.eclipse.osee.orcs.core.internal.relation.RelationFactory;

public class GraphBuilderFactory {
    private final Log logger;
    private final ArtifactFactory artifactFactory;
    private final AttributeFactory attributeFactory;
    private final RelationFactory relationFactory;

    public GraphBuilderFactory(Log logger, ArtifactFactory artifactFactory, AttributeFactory attributeFactory, RelationFactory relationFactory) {
        this.logger = logger;
        this.artifactFactory = artifactFactory;
        this.attributeFactory = attributeFactory;
        this.relationFactory = relationFactory;
    }

    public GraphBuilder createBuilderForGraph(GraphData graph) {
        return this.createGraphBuilder(GraphUtil.asProvider(graph));
    }

    public GraphBuilder createGraphBuilder(GraphProvider graphProvider) {
        return new GraphBuilderImpl(this.logger, this.artifactFactory, this.attributeFactory, this.relationFactory, graphProvider);
    }
}

