/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.Provider;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jaxrs.server.internal.JaxRsResourceManager;

@PreMatching
@Provider
public class JaxRsStaticResourceRequestFilter
implements ContainerRequestFilter {
    private static final String GET_METHOD = "GET";
    private static final String HEAD_METHOD = "HEAD";
    private JaxRsResourceManager manager;
    @Context
    private ServletContext servletContext;

    public void setJaxRsResourceManager(JaxRsResourceManager manager) {
        this.manager = manager;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        JaxRsResourceManager.Resource resource;
        Request request = requestContext.getRequest();
        String method = request.getMethod();
        if ((GET_METHOD.equals(method) || HEAD_METHOD.equals(method)) && (resource = this.manager.findResource(requestContext)) != null) {
            MultivaluedMap headers = requestContext.getHeaders();
            List mediaTypes = requestContext.getAcceptableMediaTypes();
            Response response = this.newResponse(this.servletContext, (MultivaluedMap<String, String>)headers, mediaTypes, resource);
            requestContext.abortWith(response);
        }
    }

    private Response newResponse(ServletContext servletContext, MultivaluedMap<String, String> headers, List<MediaType> acceptableMediaTypes, JaxRsResourceManager.Resource resource) throws IOException {
        String ifNoneMatch;
        final URLConnection connection = resource.getUrl().openConnection();
        long lastModified = connection.getLastModified();
        int contentLength = connection.getContentLength();
        String etag = null;
        if (lastModified != -1L && contentLength != -1) {
            etag = String.format("W/\"%s-%s\"", contentLength, lastModified);
        }
        if ((ifNoneMatch = (String)headers.getFirst((Object)"If-None-Match")) != null && etag != null && ifNoneMatch.indexOf(etag) != -1) {
            return Response.notModified().build();
        }
        Response.ResponseBuilder builder = Response.ok();
        String contentType = null;
        if (servletContext != null) {
            String externalForm = resource.getUrl().toExternalForm();
            contentType = servletContext.getMimeType(externalForm);
        }
        if (contentType != null) {
            builder.type(contentType);
        } else if (!acceptableMediaTypes.isEmpty()) {
            builder.type(acceptableMediaTypes.get(0));
        }
        if (lastModified > 0L) {
            builder.lastModified(new Date(lastModified));
        }
        if (etag != null) {
            builder.tag(etag);
        }
        StreamingOutput output = new StreamingOutput(){

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                InputStream inputStream = null;
                try {
                    inputStream = connection.getInputStream();
                    Lib.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
                }
                finally {
                    Lib.close((AutoCloseable)inputStream);
                }
            }
        };
        builder.entity((Object)output);
        return builder.build();
    }
}

