/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.rest.internal;

import javax.annotation.security.PermitAll;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.eclipse.osee.account.admin.OseePrincipal;
import org.eclipse.osee.account.rest.internal.AccountDataUtil;
import org.eclipse.osee.account.rest.internal.AccountOps;
import org.eclipse.osee.account.rest.internal.AccountResource;
import org.eclipse.osee.account.rest.model.AccountInfoData;
import org.eclipse.osee.account.rest.model.AccountInput;
import org.eclipse.osee.framework.core.data.ArtifactId;

@Path(value="accounts")
public class AccountsResource {
    @Context
    private HttpHeaders httpHeaders;
    private final AccountOps accountOps;

    public AccountsResource(AccountOps accountOps) {
        this.accountOps = accountOps;
    }

    @GET
    @Path(value="self")
    @PermitAll
    @Produces(value={"application/json", "application/xml"})
    public AccountInfoData getWhoAmI(@Context OseePrincipal principal) {
        AccountInfoData toReturn = null;
        if (principal != null) {
            toReturn = AccountDataUtil.asAccountInfoData(principal);
        }
        return toReturn;
    }

    @GET
    @Path(value="preferences/{id}")
    @PermitAll
    @Produces(value={"application/json", "application/xml"})
    public Response getPreferences(@PathParam(value="id") Long id) {
        ArtifactId artifactId = ArtifactId.valueOf((Long)id);
        return Response.ok().entity((Object)this.accountOps.getAccountWebPreferencesData(artifactId)).build();
    }

    @PUT
    @Path(value="preferences/{id}")
    @PermitAll
    @Produces(value={"application/json", "application/xml"})
    public Response editPreferences(@PathParam(value="id") String userUuid, @QueryParam(value="key") String key, @QueryParam(value="itemId") String itemId, String newValue) {
        ArtifactId artifactId = ArtifactId.valueOf((String)userUuid);
        return Response.ok().entity((Object)this.accountOps.editAccountWebPreferencesData(artifactId, key, itemId, newValue)).build();
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public AccountInfoData[] getAccounts() {
        return this.accountOps.getAllAccounts().toArray(new AccountInfoData[0]);
    }

    @POST
    @PermitAll
    @Path(value="{account-id}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public AccountInfoData createAccount(@PathParam(value="account-id") String username, AccountInput accountInput) {
        return this.accountOps.createAccount(username, accountInput);
    }

    @Path(value="{account-id}")
    public AccountResource getAccount(@PathParam(value="account-id") Long accountId) {
        ArtifactId artifactId = ArtifactId.valueOf((Long)accountId);
        return new AccountResource(this.accountOps, artifactId);
    }
}

