/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.internal.session;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.eclipse.osee.cache.admin.Cache;
import org.eclipse.osee.framework.core.data.OseeCredential;
import org.eclipse.osee.framework.core.data.OseeSessionGrant;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.server.IAuthenticationManager;
import org.eclipse.osee.framework.core.server.ISession;
import org.eclipse.osee.framework.core.server.ISessionManager;
import org.eclipse.osee.framework.core.server.internal.session.Session;
import org.eclipse.osee.framework.core.server.internal.session.SessionFactory;
import org.eclipse.osee.framework.core.server.internal.session.WriteDataAccessor;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.time.GlobalTime;

public final class SessionManagerImpl
implements ISessionManager {
    private final SessionFactory sessionFactory;
    private final Cache<String, Session> sessionCache;
    private final IAuthenticationManager authenticationManager;
    private final WriteDataAccessor<Session> storeDataAccessor;

    public SessionManagerImpl(SessionFactory sessionFactory, Cache<String, Session> sessionCache, IAuthenticationManager authenticationManager, WriteDataAccessor<Session> storeDataAccessor) {
        this.sessionFactory = sessionFactory;
        this.sessionCache = sessionCache;
        this.authenticationManager = authenticationManager;
        this.storeDataAccessor = storeDataAccessor;
    }

    @Override
    public OseeSessionGrant createSession(final OseeCredential credential) {
        Conditions.checkNotNull((Object)credential, (String)"credential");
        OseeSessionGrant sessionGrant = null;
        final String newSessionId = GUID.create();
        boolean isAuthenticated = this.authenticationManager.authenticate(credential);
        if (isAuthenticated) {
            final UserToken userToken = this.authenticationManager.asUserToken(credential);
            Callable<Session> callable = new Callable<Session>(){

                @Override
                public Session call() throws Exception {
                    Timestamp creationDate = GlobalTime.GreenwichMeanTimestamp();
                    Session session = SessionManagerImpl.this.sessionFactory.createNewSession(newSessionId, userToken.getUserId(), creationDate, credential.getClientVersion(), credential.getClientAddress(), credential.getClientAddress(), Integer.valueOf(credential.getClientPort()));
                    if (userToken.isValid() && userToken.notEqual((Id)SystemUser.OseeSystem)) {
                        SessionManagerImpl.this.storeDataAccessor.create(Collections.singleton(session));
                    }
                    return session;
                }
            };
            try {
                Session session = (Session)this.sessionCache.get((Object)newSessionId, (Callable)callable);
                sessionGrant = this.sessionFactory.createSessionGrant(session, userToken, this.authenticationManager.getProtocol());
            }
            catch (Exception e) {
                OseeCoreException.wrapAndThrow((Throwable)e);
            }
        }
        return sessionGrant;
    }

    @Override
    public void releaseSession(String sessionId) {
        this.releaseSessionImmediate(sessionId);
    }

    @Override
    public Session getSessionById(String sessionId) {
        Conditions.checkNotNull((Object)sessionId, (String)"sessionId");
        Session session = null;
        try {
            session = (Session)this.sessionCache.get((Object)sessionId);
        }
        catch (Exception exception) {
            session = null;
        }
        return session;
    }

    @Override
    public Collection<ISession> getSessionByClientAddress(String clientAddress) {
        Conditions.checkNotNull((Object)clientAddress, (String)"clientAddress");
        HashSet<ISession> sessions = new HashSet<ISession>();
        Iterable all = null;
        try {
            all = this.sessionCache.getAll();
        }
        catch (Exception e) {
            OseeCoreException.wrapAndThrow((Throwable)e);
        }
        if (all != null) {
            for (Session session : all) {
                if (!session.getClientAddress().equals(clientAddress)) continue;
                sessions.add(session);
            }
        }
        return sessions;
    }

    @Override
    public Collection<ISession> getSessionsByUserId(String userId) {
        Conditions.checkNotNull((Object)userId, (String)"userId");
        HashSet<ISession> toReturn = new HashSet<ISession>();
        for (ISession session : this.getAllSessions()) {
            if (!session.getUserId().equals(userId)) continue;
            toReturn.add(session);
        }
        return toReturn;
    }

    @Override
    public Collection<ISession> getAllSessions() {
        HashSet<ISession> toReturn = new HashSet<ISession>();
        try {
            Iterable all = this.sessionCache.getAll();
            for (Session session : all) {
                toReturn.add(session);
            }
        }
        catch (Exception e) {
            OseeCoreException.wrapAndThrow((Throwable)e);
        }
        return toReturn;
    }

    @Override
    public void releaseSessionImmediate(String ... sessionIds) {
        Conditions.checkNotNull((Object)sessionIds, (String)"sessionIds");
        HashSet<Session> sessions = new HashSet<Session>();
        String[] stringArray = sessionIds;
        int n = sessionIds.length;
        int n2 = 0;
        while (n2 < n) {
            String sessionId = stringArray[n2];
            Session session = this.getSessionById(sessionId);
            if (session != null) {
                sessions.add(session);
            }
            ++n2;
        }
        if (!sessions.isEmpty()) {
            this.storeDataAccessor.delete(sessions);
        }
        this.sessionCache.invalidate(Arrays.asList(sessionIds));
    }
}

