/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writers.reflection;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class ASTParserUtil {
    private final List<String> classPaths = new ArrayList<String>();

    public CompilationUnit parse(String javaCode) {
        ASTParser parser = ASTParser.newParser((int)10);
        parser.setSource(javaCode.toCharArray());
        parser.setKind(8);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        Hashtable options = JavaCore.getOptions();
        parser.setCompilerOptions((Map)options);
        String unitName = this.getUnitNameFromCode(javaCode);
        parser.setUnitName(unitName);
        parser.setEnvironment(this.classPaths.toArray(new String[0]), null, null, true);
        CompilationUnit cUnit = (CompilationUnit)parser.createAST(null);
        return cUnit;
    }

    public CompilationUnit parseFile(String fileName) {
        File toParse = new File(fileName);
        if (toParse.isFile()) {
            try {
                String javaCode = Lib.fileToString((File)toParse);
                return this.parse(javaCode);
            }
            catch (IOException ex) {
                throw new OseeCoreException("AST Parser failure", (Throwable)ex);
            }
        }
        throw new OseeCoreException("Invalid file %s provided to AST Parser", new Object[]{fileName});
    }

    public List<String> getParsedProblems(CompilationUnit parsed) {
        IProblem[] iproblems;
        ArrayList<String> problems = new ArrayList<String>();
        IProblem[] iProblemArray = iproblems = parsed.getProblems();
        int n = iproblems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            problems.add(problem.getMessage());
            ++n2;
        }
        return problems;
    }

    public void addClassPath(String path) {
        this.classPaths.add(path);
    }

    public List<String> getPaths() {
        return this.classPaths;
    }

    private String getUnitNameFromCode(String code) {
        Matcher matcher = Pattern.compile("\\sclass\\s+(\\w+)").matcher(code);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new OseeArgumentException("ASTParser: No class found in the given text", new Object[0]);
    }
}

