/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.util.List;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.health.ServerStatus;
import org.eclipse.osee.orcs.health.StatusKey;
import org.eclipse.osee.orcs.rest.internal.health.operations.ServerUtils;

public class ServerHealthLogs {
    private final JdbcClient jdbcClient;

    public ServerHealthLogs(JdbcClient jdbcClient) {
        this.jdbcClient = jdbcClient;
    }

    public String getHtml() {
        List<String> servers = ServerUtils.getServers(this.jdbcClient);
        if (servers.size() == 0) {
            return AHTML.simplePage((String)"No osee.health.servers configured in osee_info table");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<h3>OSEE Health - Server Health - Logs</h3>");
        sb.append("Select to see server log<br/><br/>");
        for (String server : servers) {
            String serverLogCurlUrl = this.getServerLogCurlUrl(server);
            if (serverLogCurlUrl.startsWith("Error")) {
                sb.append(String.valueOf(server) + " - " + serverLogCurlUrl);
            } else {
                sb.append(AHTML.getHyperlinkNewTab((String)serverLogCurlUrl, (String)server));
            }
            sb.append("<br/><br/>");
        }
        String html = AHTML.simplePage((String)sb.toString());
        return html;
    }

    private String getServerLogCurlUrl(String server) {
        try {
            String statusUrlStr = String.format("http://%s%s", server, "/server/health/status");
            String statusResults = ServerUtils.getUrlResults(statusUrlStr);
            if (statusResults.contains("{\"data\" ")) {
                ServerStatus stat = (ServerStatus)JsonUtil.readValue((String)statusResults, ServerStatus.class);
                String appServerDir = stat.get(StatusKey.CodeLocation);
                String uri = stat.get(StatusKey.ServerUri);
                uri = uri.replaceFirst("http://", "");
                uri = uri.replaceFirst(":.*$", "");
                String port = stat.get(StatusKey.ServerUri);
                port = port.replaceFirst("^.*:", "");
                String filename = String.format("osee_app_server_%s_%s.log", uri, port);
                String catLogCmd = String.format("cat %s/logs/%s", appServerDir, filename);
                String curlExecUrl = ServerUtils.getCurlExecUrl(catLogCmd, this.jdbcClient);
                return curlExecUrl;
            }
            return String.format("Error: Unsuccessful reading health/status for server [%s] results [%s]", server, statusResults);
        }
        catch (Exception ex) {
            return "Error: " + ex.getMessage();
        }
    }
}

