/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.branch;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.UpdateBranchData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;

public class UpdateBranchOperation {
    private final BranchId toBranchId;
    private final BranchId fromBranchId;
    private final UpdateBranchData branchData;
    private final OrcsApi orcsApi;

    public UpdateBranchOperation(UpdateBranchData branchData, OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.toBranchId = branchData.getToBranch();
        this.fromBranchId = branchData.getFromBranch();
        this.branchData = branchData;
    }

    public UpdateBranchData run() {
        try {
            if (this.toBranchId.isInvalid()) {
                this.branchData.getResults().errorf("Update Branch toBranch is invalid [%s]", new Object[]{this.toBranchId});
                return this.branchData;
            }
            if (this.fromBranchId.isInvalid()) {
                this.branchData.getResults().errorf("Update Branch fromBranch is invalid [%s]", new Object[]{this.fromBranchId});
                return this.branchData;
            }
            Branch fromBranch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(this.fromBranchId)).getResults().getOneOrNull();
            if (fromBranch.isInvalid()) {
                this.branchData.getResults().errorf("Update Branch fromBranch can't be found [%s]", new Object[]{this.fromBranchId});
                return this.branchData;
            }
            BranchToken toBranch = BranchToken.create((String)this.branchData.getToName());
            this.branchData.setNewBranchId((BranchId)this.orcsApi.getBranchOps().createWorkingBranch(toBranch, (BranchToken)fromBranch, ArtifactId.SENTINEL));
            this.branchData.getResults().logf("Update Branch [%s]", new Object[]{fromBranch.getShortName()});
        }
        catch (Exception ex) {
            this.branchData.getResults().errorf("Exception in Update Operation: %s", new Object[]{Lib.exceptionToString((Exception)ex)});
            return this.branchData;
        }
        return this.branchData;
    }
}

