/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.JaxRsApi;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.data.OseeClient;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;

@Provider
public class AuthenticationRequestFilter
implements ContainerRequestFilter {
    private OrcsApi orcsApi;
    private JaxRsApi jaxRsApi;
    private ActivityLog activityLog;

    public void bindOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.jaxRsApi = orcsApi.jaxRsApi();
        this.activityLog = orcsApi.getActivityLog();
    }

    public void filter(ContainerRequestContext requestContext) {
        try {
            String authHeader = requestContext.getHeaderString("Authorization");
            if (authHeader != null) {
                String jwtLoginKey = this.orcsApi.userService().getLoginKey();
                if (Strings.isValid((String)jwtLoginKey)) {
                    String[] authArray = authHeader.split(" ");
                    if (authArray.length == 2) {
                        String[] jwt = authArray[1].split("\\.");
                        Base64.Decoder urlDecoder = Base64.getUrlDecoder();
                        String payloadJson = new String(urlDecoder.decode(jwt[1]), StandardCharsets.UTF_8);
                        String loginId = this.jaxRsApi.readValue(payloadJson, jwtLoginKey);
                        this.orcsApi.userService().setUserForCurrentThread(loginId);
                    }
                } else if (authHeader.startsWith("Basic ")) {
                    this.orcsApi.userService().setUserForCurrentThread(authHeader.substring("Basic ".length()));
                } else {
                    this.orcsApi.userService().setUserForCurrentThread(UserId.valueOf((String)authHeader));
                }
            }
        }
        catch (Exception ex) {
            this.orcsApi.getActivityLog().createThrowableEntry(CoreActivityTypes.OSEE_ERROR, (Throwable)ex);
        }
        if (this.activityLog.isEnabled()) {
            try {
                String message = String.format("%s %s", requestContext.getMethod(), requestContext.getUriInfo().getPath());
                String clientStr = requestContext.getHeaderString("osee.client.id");
                Long clientId = Strings.isValid((String)clientStr) ? Long.valueOf(clientStr) : Id.SENTINEL;
                Long serverId = OseeClient.getPort();
                Long entryId = this.activityLog.createActivityThread(CoreActivityTypes.JAXRS_METHOD_CALL, (UserId)this.orcsApi.userService().getUser(), serverId, clientId, new Object[]{message});
                requestContext.setProperty("X-osee-activity-log-entryId", (Object)entryId);
            }
            catch (Throwable th) {
                this.activityLog.createThrowableEntry(CoreActivityTypes.JAXRS_METHOD_CALL_FILTER_ERROR, th);
            }
        }
    }
}

