/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.mim.MimApi;
import org.eclipse.osee.mim.MimImportEndpoint;
import org.eclipse.osee.mim.internal.IcdImportApiImpl;
import org.eclipse.osee.mim.internal.PlatformTypeImportApiImpl;
import org.eclipse.osee.mim.types.MimImportSummary;
import org.eclipse.osee.mim.types.MimImportToken;

public class MimImportEndpointImpl
implements MimImportEndpoint {
    private final MimApi mimApi;

    public MimImportEndpointImpl(MimApi mimApi) {
        this.mimApi = mimApi;
    }

    @Override
    public List<MimImportToken> getImportOptions() {
        return this.mimApi.getMimArtifactsApi().getMimImports();
    }

    @Override
    public MimImportSummary getImportSummary(BranchId branch, String fileName, InputStream stream) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            stream.transferTo(outputStream);
            IcdImportApiImpl importer = new IcdImportApiImpl(branch, fileName, new ByteArrayInputStream(outputStream.toByteArray()), this.mimApi);
            outputStream.close();
            stream.close();
            return importer.getSummary();
        }
        catch (IOException ex) {
            System.out.println(ex);
            return new MimImportSummary();
        }
    }

    @Override
    public MimImportSummary getTypesImportSummary(InputStream stream) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            stream.transferTo(outputStream);
            PlatformTypeImportApiImpl importer = new PlatformTypeImportApiImpl(new ByteArrayInputStream(outputStream.toByteArray()), this.mimApi);
            outputStream.close();
            stream.close();
            return importer.getSummary();
        }
        catch (IOException ex) {
            System.out.println(ex);
            return new MimImportSummary();
        }
    }
}

