/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs;

import java.util.List;

public abstract class JaxRsConfirmAccessHandler {
    public abstract ConfirmAccessResponse onConfirmAccess(ConfirmAccessRequest var1);

    protected ConfirmAccessResponse acceptAll(ConfirmAccessRequest request) {
        return new AcceptAllResponse(request);
    }

    private static final class AcceptAllResponse
    implements ConfirmAccessResponse {
        private final ConfirmAccessRequest request;

        public AcceptAllResponse(ConfirmAccessRequest request) {
            this.request = request;
        }

        @Override
        public boolean isGranted() {
            return true;
        }

        @Override
        public List<? extends Permission> getPermissionsGranted() {
            return this.request.getPermissionsRequested();
        }

        public String toString() {
            return "AcceptAllResponse [isGranted()=" + this.isGranted() + ", getPermissionsGranted()=" + this.getPermissionsGranted() + "]";
        }
    }

    public static interface ConfirmAccessRequest {
        public String getApplicationName();

        public String getApplicationDescription();

        public String getApplicationLogoUri();

        public String getApplicationWebUri();

        public String getEndUserName();

        public List<? extends Permission> getPermissionsRequested();
    }

    public static interface ConfirmAccessResponse {
        public boolean isGranted();

        public List<? extends Permission> getPermissionsGranted();
    }

    public static interface Permission {
        public String getName();

        public String getDescription();

        public boolean isDefault();
    }
}

