/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.workflow.WorkItem;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;

public class TeamWorkflow
extends WorkItem
implements IAtsTeamWorkflow {
    IAtsTeamDefinition teamDef = null;

    public TeamWorkflow(Log logger, AtsApi atsApi, ArtifactToken artifact) {
        super(logger, atsApi, artifact, AtsArtifactTypes.TeamWorkflow);
    }

    public Set<IAtsActionableItem> getActionableItems() {
        HashSet<IAtsActionableItem> ais = new HashSet<IAtsActionableItem>();
        Collection artIds = this.atsApi.getAttributeResolver().getArtifactIdReferences(this.artifact, (AttributeTypeToken)AtsAttributeTypes.ActionableItemReference);
        for (ArtifactId artId : artIds) {
            IAtsActionableItem ai = (IAtsActionableItem)this.atsApi.getConfigService().getConfigurations().getIdToAi().get(artId.getId());
            if (ai == null) {
                ai = (IAtsActionableItem)this.atsApi.getQueryService().getConfigItem(artId);
            }
            Conditions.assertNotNull((Object)ai, (String)"ai can not be null for artId %s", (Object[])new Object[]{artId});
            ais.add(ai);
        }
        return ais;
    }

    public IAtsTeamDefinition getTeamDefinition() {
        ArtifactId teamDefId;
        if (this.teamDef == null && (teamDefId = this.atsApi.getAttributeResolver().getSoleArtifactIdReference(this.artifact, (AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, ArtifactId.SENTINEL)).isValid()) {
            this.teamDef = this.atsApi.getTeamDefinitionService().getTeamDefinitionById(teamDefId);
        }
        return this.teamDef;
    }

    @Override
    public List<WorkType> getWorkTypes() {
        return new ArrayList<WorkType>(this.getTeamDefinition().getWorkTypes());
    }
}

