/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.review;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsDecisionReviewDefinition;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.StateEventType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsReviewHook;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class DecisionReviewOnTransitionToHook
implements IAtsTransitionHook {
    public static IAtsDecisionReview createNewDecisionReview(IAtsDecisionReviewDefinition revDef, IAtsChangeSet changes, IAtsTeamWorkflow teamWf, Date createdDate, AtsUser createdBy) {
        if (Named.getNames((Collection)AtsApiService.get().getReviewService().getReviews(teamWf)).contains(revDef.getReviewTitle())) {
            return null;
        }
        LinkedList<AtsUser> users = new LinkedList<AtsUser>();
        users.addAll(AtsApiService.get().getUserService().getUsersByUserIds((Collection)revDef.getAssignees()));
        if (users.isEmpty()) {
            users.add(AtsApiService.get().getUserService().getCurrentUser());
        }
        if (!Strings.isValid((String)revDef.getReviewTitle())) {
            throw new OseeStateException("ReviewDefinition must specify title for Team Workflow [%s] WorkDefinition [%s]", new Object[]{teamWf.toStringWithId(), teamWf.getWorkDefinition()});
        }
        IAtsDecisionReview decArt = null;
        decArt = revDef.isAutoTransitionToDecision() ? (IAtsDecisionReview)AtsApiService.get().getReviewService().createNewDecisionReviewAndTransitionToDecision(teamWf, revDef.getReviewTitle(), revDef.getDescription(), revDef.getRelatedToState(), revDef.getBlockingType(), (Collection)revDef.getOptions(), users, createdDate, createdBy, changes).getStoreObject() : AtsApiService.get().getReviewService().createNewDecisionReview(teamWf, revDef.getBlockingType(), revDef.getReviewTitle(), revDef.getRelatedToState(), revDef.getDescription(), (Collection)revDef.getOptions(), users, createdDate, createdBy, changes);
        decArt.getLog().addLog(LogType.Note, null, String.format("Review [%s] auto-generated", revDef.getName()), AtsApiService.get().getUserService().getCurrentUser().getUserId());
        for (IAtsReviewHook provider : AtsApiService.get().getReviewService().getReviewHooks()) {
            provider.reviewCreated((IAtsAbstractReview)decArt);
        }
        changes.add((Object)decArt);
        return decArt;
    }

    public void transitioned(IAtsWorkItem workItem, IStateToken fromState, IStateToken toState, Collection<? extends AtsUser> toAssignees, AtsUser asUser, IAtsChangeSet changes) {
        if (!(workItem instanceof IAtsTeamWorkflow)) {
            return;
        }
        Date createdDate = new Date();
        AtsUser createdBy = AtsCoreUsers.SYSTEM_USER;
        IAtsTeamWorkflow teamArt = (IAtsTeamWorkflow)workItem;
        for (IAtsDecisionReviewDefinition decRevDef : workItem.getStateDefinition().getDecisionReviews()) {
            IAtsDecisionReview decArt;
            if (decRevDef.getStateEventType() == null || !decRevDef.getStateEventType().equals((Object)StateEventType.TransitionTo) || (decArt = DecisionReviewOnTransitionToHook.createNewDecisionReview(decRevDef, changes, teamArt, createdDate, createdBy)) == null) continue;
            changes.add((Object)decArt);
        }
    }

    public String getDescription() {
        return "Create DecisionReview from transition if defined by StateDefinition";
    }
}

