/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.model.impl;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.core.model.impl.AtsObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.logger.Log;

public abstract class AtsConfigObject
extends AtsObject
implements IAtsConfigObject {
    protected ArtifactToken artifact;
    protected final Log logger;
    protected final AtsApi atsApi;

    public AtsConfigObject(Log logger, AtsApi atsApi, ArtifactToken artifact, ArtifactTypeToken artifactType) {
        super(artifact.getName(), artifact.getId());
        this.logger = logger;
        this.atsApi = atsApi;
        this.artifact = artifact;
        this.setStoreObject(artifact);
    }

    public Log getLogger() {
        return this.logger;
    }

    @Override
    public AtsApi getAtsApi() {
        return this.atsApi;
    }

    public Boolean isActionable() {
        return (Boolean)this.getAttributeValue((AttributeTypeToken)AtsAttributeTypes.Actionable, false);
    }

    protected <T> T getAttributeValue(AttributeTypeToken attributeType, Object defaultValue) {
        Object value = null;
        try {
            value = this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, attributeType, defaultValue);
        }
        catch (OseeCoreException ex) {
            this.logger.error((Throwable)ex, "Error getting attribute value for - attributeType[%s]", new Object[]{attributeType});
        }
        return (T)value;
    }

    public boolean isActive() {
        if (this.atsApi.getStoreService().isDeleted((ArtifactId)this.artifact)) {
            return false;
        }
        return (Boolean)this.getAttributeValue((AttributeTypeToken)AtsAttributeTypes.Active, false);
    }

    public Long getId() {
        return this.artifact.getId();
    }

    @Override
    public String getDescription() {
        return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)"");
    }

    public ArtifactToken loadStoreObject() {
        if (this.artifact == null) {
            throw new RuntimeException("artifact is null");
        }
        ArtifactToken art = this.atsApi.getQueryService().getArtifact(this.artifact.getId());
        if (art.isValid()) {
            this.setStoreObject(art);
        }
        return art;
    }

    @Override
    public ArtifactToken getStoreObject() {
        if (this.artifact != null) {
            return this.artifact;
        }
        if (super.getStoreObject() == null) {
            return this.loadStoreObject();
        }
        return super.getStoreObject();
    }
}

