/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.util;

import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.ISequenceProvider;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.IWorkItemListener;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class AtsIdProvider {
    protected static final String DEFAULT_ACTION_SEQ_NAME = "ATS_ACTION_ID_SEQ";
    protected static final String DEFAULT_ACTION_ID_PREFIX = "ACT";
    protected static final String DEFAULT_TASK_SEQ_NAME = "ATS_TASK_ID_SEQ";
    protected static final String DEFAULT_TASK_ID_PREFIX = "TSK";
    protected static final String DEFAULT_REVIEW_SEQ_NAME = "ATS_REVIEW_ID_SEQ";
    protected static final String DEFAULT_REVIEW_ID_PREFIX = "RVW";
    protected static final String DEFAULT_WORKFLOW_SEQ_NAME = "ATS_WORKFLOW_ID_SEQ";
    protected static final String DEFAULT_WORKFLOW_ID_PREFIX = "TW";
    protected static final String DEFAULT_SEQ_NAME = "ATS_ID_SEQ";
    protected static final String DEFAULT_ID_PREFIX = "ATS";
    private final IAtsObject newObject;
    private final IAtsTeamDefinition teamDef;
    private final IAttributeResolver attrResolver;
    private final ISequenceProvider sequenceProvider;
    private IWorkItemListener workItemListener;

    public AtsIdProvider(ISequenceProvider sequenceProvider, IAttributeResolver attrResolver, IAtsObject newObject, IAtsTeamDefinition teamDef) {
        this.sequenceProvider = sequenceProvider;
        this.attrResolver = attrResolver;
        this.newObject = newObject;
        this.teamDef = teamDef;
    }

    public String getNextAtsId() {
        String seqName = "";
        if (this.newObject.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            seqName = this.getAttrValueFromTeamDef((AttributeTypeToken)AtsAttributeTypes.AtsIdSequenceName);
            if (Strings.isInValid((String)seqName)) {
                seqName = DEFAULT_WORKFLOW_SEQ_NAME;
            }
        } else {
            seqName = this.newObject.isTypeEqual((ArtifactTypeId)AtsArtifactTypes.Action) ? DEFAULT_ACTION_SEQ_NAME : (this.newObject.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractReview}) ? DEFAULT_REVIEW_SEQ_NAME : (this.newObject.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task}) ? DEFAULT_TASK_SEQ_NAME : DEFAULT_SEQ_NAME));
        }
        String prefixName = null;
        if (this.workItemListener != null) {
            prefixName = this.workItemListener.getWorkItemAtsIdPrefix(this.newObject);
        }
        if (Strings.isInValid(prefixName)) {
            if (this.newObject.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                prefixName = this.getAttrValueFromTeamDef((AttributeTypeToken)AtsAttributeTypes.AtsIdPrefix);
                if (Strings.isInValid((String)prefixName)) {
                    prefixName = DEFAULT_WORKFLOW_ID_PREFIX;
                }
            } else {
                prefixName = this.newObject.isTypeEqual((ArtifactTypeId)AtsArtifactTypes.Action) ? DEFAULT_ACTION_ID_PREFIX : (this.newObject.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractReview}) ? DEFAULT_REVIEW_ID_PREFIX : (this.newObject.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task}) ? DEFAULT_TASK_ID_PREFIX : DEFAULT_ID_PREFIX));
            }
        }
        return this.getNextId(prefixName, seqName);
    }

    public void setAtsId(IAtsChangeSet changes) {
        String atsId = this.attrResolver.getSoleAttributeValueAsString(this.newObject, (AttributeTypeToken)AtsAttributeTypes.AtsId, null);
        if (!Strings.isValid((String)atsId) || atsId.equals("0")) {
            String id = this.getNextAtsId();
            this.attrResolver.setSoleAttributeValue(this.newObject, (AttributeTypeToken)AtsAttributeTypes.AtsId, (Object)id, changes);
        }
    }

    protected String getNextId(String prefix, String seqName) {
        return String.format("%s%d", prefix, this.sequenceProvider.getNext(seqName));
    }

    protected String getAttrValueFromTeamDef(AttributeTypeToken attrType) {
        IAtsTeamDefinition parentTeamDef;
        String attrValue = this.attrResolver.getSoleAttributeValueAsString((IAtsObject)this.teamDef, attrType, null);
        if (!Strings.isValid((String)attrValue) && (parentTeamDef = this.teamDef.getAtsApi().getTeamDefinitionService().getTeamDefHoldingVersions(this.teamDef)) != null) {
            attrValue = this.attrResolver.getSoleAttributeValueAsString((IAtsObject)parentTeamDef, attrType, null);
        }
        return attrValue;
    }

    public IWorkItemListener getWorkItemListener() {
        return this.workItemListener;
    }

    public void setWorkItemListener(IWorkItemListener workItemListener) {
        this.workItemListener = workItemListener;
    }
}

