/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.access.IAtsAccessContextProvider;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.access.AccessContextResult;
import org.eclipse.osee.framework.core.access.AccessContextResults;
import org.eclipse.osee.framework.core.access.AccessControlUtil;
import org.eclipse.osee.framework.core.access.AccessTypeMatch;
import org.eclipse.osee.framework.core.access.context.AccessContext;
import org.eclipse.osee.framework.core.access.context.AccessType;
import org.eclipse.osee.framework.core.access.context.IParentProvider;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;

public abstract class AbstractAtsAccessContextProvider
implements IAtsAccessContextProvider {
    protected AtsApi atsApi;

    public boolean isApplicable(AtsUser atsUser, Object object) {
        boolean result = false;
        if (object instanceof ArtifactToken) {
            result = this.isApplicable((BranchId)((ArtifactToken)object).getBranch());
        }
        if (object instanceof BranchId) {
            result = this.isApplicable((BranchId)object);
        }
        return result;
    }

    public abstract boolean isApplicableDb();

    public boolean isAtsApplicable(BranchId branch, ArtifactToken assocArt) {
        boolean isApplicableDb = this.isApplicableDb();
        if (!isApplicableDb) {
            return false;
        }
        boolean applicable = false;
        if (branch.isValid()) {
            boolean isAtsBranch;
            BranchType branchType = this.atsApi.getBranchService().getBranchType(branch);
            if (branchType == BranchType.WORKING) {
                applicable = this.isAtsApplicable(AtsApiService.get().getBranchService().getParentBranch(branch), assocArt);
            } else if (branchType == BranchType.BASELINE && (isAtsBranch = assocArt.notEqual((Id)AtsArtifactToken.AtsCmBranch))) {
                applicable = true;
            }
        }
        return applicable;
    }

    public boolean isApplicable(BranchId branch) {
        boolean applicable = false;
        try {
            if (this.atsApi.getAtsBranch().notEqual((Id)branch)) {
                ArtifactToken assocArt = null;
                ArtifactId associatedArtifact = this.atsApi.getBranchService().getAssociatedArtifactId(branch);
                if (associatedArtifact.isValid()) {
                    if (associatedArtifact.equals(AtsArtifactToken.AtsCmBranch)) {
                        applicable = true;
                    } else {
                        assocArt = this.atsApi.getQueryService().getArtifact(associatedArtifact);
                        applicable = assocArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow});
                    }
                }
                if (applicable && assocArt != null) {
                    applicable = this.isAtsApplicable(branch, assocArt);
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(this.getClass(), (Level)Level.INFO, (String)"Error determining access applicibility", (Throwable)ex);
        }
        return applicable;
    }

    public XResultData hasAttributeTypeContextWriteAccess(AtsUser atsUser, Collection<? extends ArtifactToken> artifacts, AttributeTypeToken attributeType, XResultData rd) {
        this.checkContextWrite(artifacts, attributeType, (RelationTypeToken)RelationTypeSide.SENTINEL, rd);
        return rd;
    }

    public XResultData hasArtifactContextWriteAccess(AtsUser atsUser, Collection<? extends ArtifactToken> artifacts, XResultData rd) {
        this.checkContextWrite(artifacts, (AttributeTypeToken)AttributeTypeToken.SENTINEL, (RelationTypeToken)RelationTypeSide.SENTINEL, rd);
        return rd;
    }

    public XResultData hasRelationContextWriteAccess(AtsUser atsUser, ArtifactToken artifact, RelationTypeToken relationType, XResultData rd) {
        this.checkContextWrite(Collections.singleton(artifact), (AttributeTypeToken)AttributeTypeToken.SENTINEL, relationType, rd);
        return rd;
    }

    private XResultData checkContextWrite(Collection<? extends ArtifactToken> artifacts, AttributeTypeToken attrType, RelationTypeToken relType, XResultData rd) {
        Collection contextIds = this.atsApi.getAtsAccessService().getContextIds((BranchId)artifacts.iterator().next().getBranch());
        for (ArtifactToken artifactToken : artifacts) {
            AccessContextResults accessResults = new AccessContextResults();
            accessResults.setArtifact(artifactToken);
            PermissionEnum artPerm = PermissionEnum.READ;
            if (contextIds.isEmpty()) {
                accessResults.setReason("Context Id: No Context Ids found for branch " + artifacts.iterator().next().getBranch().toStringWithId());
                artPerm = PermissionEnum.FULLACCESS;
            } else {
                Collection contexts = AccessControlUtil.getContexts((Collection)contextIds, (XResultData)rd);
                if (rd.isErrors()) {
                    return rd;
                }
                block1: for (AccessContext context : contexts) {
                    AccessContextResult aResult = new AccessContextResult();
                    accessResults.getContextResults().add(aResult);
                    aResult.setContextId(context.getAccessToken());
                    aResult.setContext(context);
                    ArrayList accessTypes = new ArrayList();
                    accessTypes.addAll(context.getTypeAccess());
                    Collections.reverse(accessTypes);
                    aResult.setAccessTypes(accessTypes);
                    for (AccessType accessType : accessTypes) {
                        AccessTypeMatch match = accessType.computeMatch(artifactToken, attrType, relType, (IParentProvider)this.atsApi.getRelationResolver());
                        aResult.setAccessTypeMatch(accessType, match);
                        if (match.isDeny()) {
                            artPerm = PermissionEnum.READ;
                            accessResults.setFinalMatch(match);
                            accessResults.setReason("ContextId: Context " + context.getAccessToken().toStringWithId());
                            continue block1;
                        }
                        if (!match.isAllow()) continue;
                        artPerm = PermissionEnum.WRITE;
                        accessResults.setFinalMatch(match);
                        accessResults.setReason("ContextId: Context " + context.getAccessToken().toStringWithId());
                        continue block1;
                    }
                }
            }
            XResultData results = accessResults.getResults();
            rd.addRaw(results.toString());
            if (artPerm.matches(PermissionEnum.WRITE)) continue;
            if (attrType.isValid()) {
                rd.errorf("Context Id: Attr Type [%s] Artifact %s DOES NOT have WRITE access.", new Object[]{attrType, artifactToken.toStringWithId()});
                continue;
            }
            if (relType.isValid()) {
                rd.errorf("Context Id: Rel Type [%s] Artifact %s DOES NOT have WRITE access.", new Object[]{relType, artifactToken.toStringWithId()});
                continue;
            }
            rd.errorf("Context Id: Artifact %s DOES NOT have WRITE access.", new Object[]{artifactToken.toStringWithId()});
        }
        return rd;
    }
}

