/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.resources;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.resources.AnnotationResource;
import org.eclipse.osee.framework.core.data.BranchId;

public class DispoItemResource {
    private final DispoApi dispoApi;
    private final BranchId branch;
    private final String setId;

    public DispoItemResource(DispoApi dispoApi, BranchId branch, String setId) {
        this.dispoApi = dispoApi;
        this.branch = branch;
        this.setId = setId;
    }

    @GET
    @Produces(value={"application/json"})
    public Iterable<DispoItem> getAllDispoItems(@QueryParam(value="isDetailed") Boolean isDetailed) {
        List<DispoItem> allDispoItems = this.dispoApi.getDispoItems(this.branch, this.setId, isDetailed);
        return allDispoItems;
    }

    @Path(value="{itemId}")
    @GET
    @Produces(value={"application/json"})
    public DispoItem getDispoItemsById(@PathParam(value="itemId") String itemId) {
        return this.dispoApi.getDispoItemById(this.branch, itemId);
    }

    @Path(value="getDispoItemId")
    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public String getDispoItemId(@FormParam(value="name") String itemName) {
        return this.dispoApi.getDispoItemIdByName(this.branch, this.setId, itemName);
    }

    @Path(value="{itemId}")
    @PUT
    @Consumes(value={"application/json"})
    public Response putDispoItem(@PathParam(value="itemId") String itemId, DispoItemData newDispoItem, @QueryParam(value="userName") String userName, @QueryParam(value="assignUser") boolean assignUser) {
        boolean wasEdited = this.dispoApi.editDispoItem(this.branch, itemId, newDispoItem, userName, assignUser);
        Response response = wasEdited ? Response.status((Response.Status)Response.Status.OK).build() : Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)"Dispositonable Item was not found").build();
        return response;
    }

    @Path(value="{itemId}")
    @DELETE
    public Response deleteDispoItem(@PathParam(value="itemId") String itemId, @QueryParam(value="userName") String userName) {
        boolean wasEdited = this.dispoApi.deleteDispoItem(this.branch, itemId, userName);
        Response response = wasEdited ? Response.status((Response.Status)Response.Status.OK).build() : Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Dispositonable Item was not found").build();
        return response;
    }

    @Path(value="{itemId}/annotation/")
    public AnnotationResource getAnnotation(@PathParam(value="itemId") String itemId) {
        return new AnnotationResource(this.dispoApi, this.branch, this.setId, itemId);
    }
}

