/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal.wordupdate;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.osee.define.api.WordTemplateContentData;
import org.eclipse.osee.define.operations.publishing.PublishingUtils;
import org.eclipse.osee.define.operations.publishing.WordCoreUtilServer;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMLApplicabilityHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMlLinkHandler;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.util.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryFactory;

public class WordTemplateContentRendererHandler {
    public static final String PGNUMTYPE_START_1 = "<w:pgNumType [^>]*w:start=\"1\"/>";
    public static final String PL_STYLE_WITH_RETURN = "<w:rPr><w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>)).*?</w:rPr>";
    public static final String PL_STYLE = "<w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>))";
    public static final String PL_HIGHLIGHT = "<w:highlight w:val=\"light-gray\"></w:highlight><w:shd w:color=\"auto\" w:fill=\"BFBFBF\" w:val=\"clear\"></w:shd>";
    public static final String EMPTY_PARAGRAPHS = "<w:r wsp:rsidRPr=\"\\d+\"><w:t></w:t></w:r>";
    public static final String EXTRA_SPACES = "<w:r><w:t> </w:t></w:r>";
    private final OrcsApi orcsApi;
    private final Log logger;
    private WordMLApplicabilityHandler applicHandler;
    private final QueryFactory queryFactory;
    private final PublishingUtils publishingUtils;

    public WordTemplateContentRendererHandler(OrcsApi orcsApi, Log logger) {
        this.orcsApi = orcsApi;
        this.queryFactory = orcsApi.getQueryFactory();
        this.logger = logger;
        this.publishingUtils = new PublishingUtils(orcsApi);
    }

    public Pair<String, Set<String>> renderWordMLForArtifact(ArtifactReadable artifact, WordTemplateContentData wtcData) {
        int lastIndex;
        String data = (String)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.WordTemplateContent, DeletionFlag.EXCLUDE_DELETED, null);
        if (Objects.isNull(data) && wtcData.getIsEdit()) {
            data = (String)CoreArtifactTypes.MsWordTemplate.getAttributeDefault((AttributeTypeGeneric)CoreAttributeTypes.WordTemplateContent);
        }
        HashSet<String> unknownGuids = new HashSet<String>();
        if (Objects.isNull(data)) {
            if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                data = "";
                data = WordMlLinkHandler.link(this.queryFactory, wtcData.getLinkType(), artifact, data, wtcData.getTxId(), unknownGuids, wtcData.getPresentationType(), wtcData.getPermanentLinkUrl());
                data = WordCoreUtilServer.reassignBookMarkID(data).toString();
                data = WordCoreUtilServer.removeNewLines(data);
                return new Pair((Object)data, unknownGuids);
            }
            return null;
        }
        data = WordCoreUtilServer.reassignBinDataID(data);
        if (wtcData.getArtIsChanged()) {
            data = WordCoreUtilServer.appendInlineChangeTag(data);
        }
        data = WordCoreUtilServer.removeNewLines(data);
        data = WordMlLinkHandler.link(this.queryFactory, wtcData.getLinkType(), artifact, data, wtcData.getTxId(), unknownGuids, wtcData.getPresentationType(), wtcData.getPermanentLinkUrl());
        data = WordCoreUtilServer.reassignBookMarkID(data).toString();
        CharSequence charSequenceData = WordCoreUtil.removeFootersAndNoDataRightsStatements((CharSequence)data);
        data = WordCoreUtil.replaceEmptySectionBreaksWithPageBreaks((CharSequence)charSequenceData).toString();
        if (wtcData.getIsEdit() && !data.contains("<w:tbl>") && (lastIndex = data.lastIndexOf("<w:p wsp:rsidR=")) != -1) {
            String temp = data.substring(lastIndex);
            temp = temp.replaceAll("<w:p\\s[^>]*>(<w:pPr><w:spacing[^>]*></w:spacing></w:pPr>)?</w:p>", "");
            data = String.valueOf(data.substring(0, lastIndex)) + temp;
        }
        if (!wtcData.getIsEdit() && (wtcData.getBranch().getViewId().notEqual((Id)ArtifactId.SENTINEL) || wtcData.isViewIdValid())) {
            if (this.applicHandler == null) {
                this.applicHandler = new WordMLApplicabilityHandler(this.orcsApi, this.logger, wtcData.getBranch(), wtcData.getViewId());
            }
            data = data.replaceAll(PL_STYLE_WITH_RETURN, "");
            data = data.replaceAll(PL_STYLE, "");
            data = data.replaceAll(PL_HIGHLIGHT, "");
            data = this.applicHandler.previewValidApplicabilityContent(data);
            data = data.replaceAll(EMPTY_PARAGRAPHS, "");
        }
        data = data.concat(wtcData.getFooter());
        if (!wtcData.getIsEdit()) {
            data = data.replaceAll(PGNUMTYPE_START_1, "");
        }
        return new Pair((Object)data, unknownGuids);
    }

    public Pair<String, Set<String>> renderWordML(WordTemplateContentData wtcData) {
        return (wtcData.isTxIdValid() ? this.publishingUtils.getArtifactReadablePossiblyDeletedByIdentifierAndTransactionIdWithDeleteAttributes(wtcData.getBranch(), ArtifactId.valueOf((Id)wtcData.getArtId()), wtcData.getTxId()) : this.publishingUtils.getArtifactReadablePossiblyDeletedByIdentifierWithDeletedAttributes(wtcData.getBranch(), ArtifactId.valueOf((Id)wtcData.getArtId()))).map(artifactReadable -> this.renderWordMLForArtifact((ArtifactReadable)artifactReadable, wtcData)).orElse(null);
    }
}

