/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.resolvers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.osee.define.api.importing.RoughArtifact;
import org.eclipse.osee.define.rest.importing.resolvers.IRoughArtifactTranslator;
import org.eclipse.osee.define.rest.importing.resolvers.NewArtifactImportResolver;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class DoorsBestFitArtifactResolver
extends NewArtifactImportResolver {
    private final boolean createNewIfNotExist;

    public DoorsBestFitArtifactResolver(TransactionBuilder transaction, IRoughArtifactTranslator translator, ArtifactTypeToken primaryArtifactType, ArtifactTypeToken secondaryArtifactType, boolean createNewIfNotExist, boolean deleteUnmatchedArtifacts) {
        super(transaction, translator, primaryArtifactType, secondaryArtifactType);
        this.createNewIfNotExist = createNewIfNotExist;
    }

    @Override
    public ArtifactId resolve(RoughArtifact roughArtifact, BranchId branch, ArtifactId realParentId, ArtifactId rootId) {
        ArtifactReadable realArtifact = null;
        ArtifactReadable root = roughArtifact.getOrcsApi().getQueryFactory().fromBranch(branch).andId(rootId).getArtifact();
        if (roughArtifact.getGuid() != null) {
            realArtifact = this.findMatchByGUID(roughArtifact, root);
            if (realArtifact == null) {
                realArtifact = this.findMatchBySysSpec(roughArtifact, root);
            }
            if (realArtifact != null) {
                this.getTranslator().translate(this.transaction, roughArtifact, (ArtifactId)realArtifact);
            }
        } else {
            roughArtifact.getResults().warningf("Doors Best Fit based resolver is comparing a null GUID. roughArtifactifact: [%s]. Attributes: [%s]", new Object[]{roughArtifact, roughArtifact.getAttributes()});
        }
        if (realArtifact == null && this.createNewIfNotExist) {
            return super.resolve(roughArtifact, branch, null, rootId);
        }
        return realArtifact;
    }

    private boolean guidsMatch(RoughArtifact roughArt, ArtifactReadable realArt) {
        String roughGuid = roughArt.getGuid();
        String realGuid = realArt.getGuid();
        return realGuid.equals(roughGuid);
    }

    private boolean legacyIdsMatch(RoughArtifact roughArt, ArtifactReadable realArt) {
        boolean allContained = true;
        String legacyIds = realArt.getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.LegacyId);
        if (Strings.isValid((String)legacyIds)) {
            List<String> splitIds = Arrays.asList(legacyIds.split(","));
            String roughLegacyIds = roughArt.getRoughAttribute(CoreAttributeTypes.LegacyId.getName());
            List<String> splitRoughIds = Arrays.asList(roughLegacyIds.split(","));
            for (String splitId : splitIds) {
                if (splitRoughIds.contains(splitId)) continue;
                allContained = false;
                break;
            }
        } else {
            allContained = false;
        }
        return allContained;
    }

    private ArtifactReadable findMatchByGUID(RoughArtifact roughArtifact, ArtifactReadable root) {
        List descendants = root.getDescendants();
        ArtifactReadable toReturn = null;
        for (ArtifactReadable artifact : descendants) {
            if (!this.guidsMatch(roughArtifact, artifact)) continue;
            toReturn = artifact;
            break;
        }
        return toReturn;
    }

    private ArtifactReadable findMatchBySysSpec(RoughArtifact roughArtifact, ArtifactReadable root) {
        List descendants = root.getDescendants();
        ArtifactReadable toReturn = null;
        for (ArtifactReadable artifact : descendants) {
            if (!this.legacyIdsMatch(roughArtifact, artifact)) continue;
            toReturn = artifact;
            break;
        }
        return toReturn;
    }
}

