/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.identifier;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.osee.define.operations.synchronization.identifier.Identifier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierTracker;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;

public class IdentifierTrackerCounting
implements IdentifierTracker {
    private Long identifierCount;
    private final IdentifierType identifierType;
    private final StringBuilder stringBuilder;

    IdentifierTrackerCounting(IdentifierType identifierType) {
        this.identifierType = identifierType;
        this.identifierCount = 0L;
        this.stringBuilder = new StringBuilder();
    }

    @Override
    public synchronized Identifier create(String unused) {
        if (Objects.nonNull(unused)) {
            throw new IllegalStateException();
        }
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.identifierType.getIdentifierPrefix()).append("-").append(Long.toString(this.identifierCount, 10));
        Long l = this.identifierCount;
        this.identifierCount = l + 1L;
        return new Identifier(this.stringBuilder.toString(), l, this.identifierType);
    }

    @Override
    public Optional<Identifier> getPrimaryIdentifierByForeignIdentifierString(String identifierString) {
        throw new IllegalStateException();
    }
}

