/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publishing.datarights;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.osee.define.operations.publishing.datarights.DataRightEntry;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

class DataRightEntryList
implements AutoCloseable,
Iterable<DataRightEntry>,
ToMessage {
    private List<DataRightEntry> dataRightEntries;
    private boolean isOpen;
    private final String overrideClassification;

    public DataRightEntryList(String overrideClassification) {
        this.overrideClassification = Objects.requireNonNull(overrideClassification);
        this.dataRightEntries = new LinkedList<DataRightEntry>();
        this.isOpen = true;
    }

    public void add(ArtifactId artifactId, ArtifactReadable artifactReadable) {
        if (!this.isOpen) {
            throw new IllegalStateException("DataRightEntryList::add, attempt to add an entry after the \"DataRightEntryList\" has been closed.");
        }
        DataRightEntry dataRightEntry = new DataRightEntry(artifactId, artifactReadable, this.overrideClassification);
        this.dataRightEntries.add(dataRightEntry);
    }

    @Override
    public void close() {
        if (!this.isOpen) {
            throw new IllegalStateException("DataRightEntryList::close, attempt to close the \"DataRightEntryList\" after it has been closed.");
        }
        this.isOpen = false;
        this.dataRightEntries = Collections.unmodifiableList(this.dataRightEntries);
    }

    public boolean isEmpty() {
        return this.dataRightEntries.isEmpty();
    }

    @Override
    public Iterator<DataRightEntry> iterator() {
        if (this.isOpen) {
            throw new IllegalStateException("DataRightEntryList::iterator, attempt to get an \"Iterator\" for a \"DataRightEntryList\" that is still open.");
        }
        return this.dataRightEntries.iterator();
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"DataRightEntryList").indentInc().segment((CharSequence)"isOpen", (Object)this.isOpen).segment((CharSequence)"overrideClassification", (Object)this.overrideClassification).segmentIndexedList((CharSequence)"dataRightEntries", this.dataRightEntries).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

