/**
 * Copyright (c) 2013 itemis AG and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Mark Broerkens - initial API and implementation
 * 
 */
package org.eclipse.rmf.reqif10.datatypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc --> A representation of the literals of the enumeration '<em><b>Frame Target Member0</b></em>',
 * and utility methods for working with them. <!-- end-user-doc -->
 * 
 * @see org.eclipse.rmf.reqif10.datatypes.DatatypesPackage#getFrameTargetMember0()
 * @model extendedMetaData="name='FrameTarget_._member_._0'"
 * @generated
 */
public enum FrameTargetMember0 implements Enumerator {
	/**
	 * The '<em><b>Blank</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #BLANK_VALUE
	 * @generated
	 * @ordered
	 */
	BLANK(0, "blank", "_blank"), //$NON-NLS-1$//$NON-NLS-2$

	/**
	 * The '<em><b>Self</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #SELF_VALUE
	 * @generated
	 * @ordered
	 */
	SELF(1, "self", "_self"), //$NON-NLS-1$//$NON-NLS-2$

	/**
	 * The '<em><b>Parent</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #PARENT_VALUE
	 * @generated
	 * @ordered
	 */
	PARENT(2, "parent", "_parent"), //$NON-NLS-1$//$NON-NLS-2$

	/**
	 * The '<em><b>Top</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #TOP_VALUE
	 * @generated
	 * @ordered
	 */
	TOP(3, "top", "_top"); //$NON-NLS-1$//$NON-NLS-2$

	/**
	 * The '<em><b>Blank</b></em>' literal value. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Blank</b></em>' literal object isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #BLANK
	 * @model name="blank" literal="_blank"
	 * @generated
	 * @ordered
	 */
	public static final int BLANK_VALUE = 0;

	/**
	 * The '<em><b>Self</b></em>' literal value. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Self</b></em>' literal object isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #SELF
	 * @model name="self" literal="_self"
	 * @generated
	 * @ordered
	 */
	public static final int SELF_VALUE = 1;

	/**
	 * The '<em><b>Parent</b></em>' literal value. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Parent</b></em>' literal object isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #PARENT
	 * @model name="parent" literal="_parent"
	 * @generated
	 * @ordered
	 */
	public static final int PARENT_VALUE = 2;

	/**
	 * The '<em><b>Top</b></em>' literal value. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Top</b></em>' literal object isn't clear, there really should be more of a description
	 * here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #TOP
	 * @model name="top" literal="_top"
	 * @generated
	 * @ordered
	 */
	public static final int TOP_VALUE = 3;

	/**
	 * An array of all the '<em><b>Frame Target Member0</b></em>' enumerators. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	private static final FrameTargetMember0[] VALUES_ARRAY = new FrameTargetMember0[] { BLANK, SELF, PARENT, TOP, };

	/**
	 * A public read-only list of all the '<em><b>Frame Target Member0</b></em>' enumerators. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public static final List<FrameTargetMember0> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Frame Target Member0</b></em>' literal with the specified literal value. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public static FrameTargetMember0 get(String literal) {
		for (FrameTargetMember0 result : VALUES_ARRAY) {
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Frame Target Member0</b></em>' literal with the specified name. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public static FrameTargetMember0 getByName(String name) {
		for (FrameTargetMember0 result : VALUES_ARRAY) {
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Frame Target Member0</b></em>' literal with the specified integer value. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public static FrameTargetMember0 get(int value) {
		switch (value) {
		case BLANK_VALUE:
			return BLANK;
		case SELF_VALUE:
			return SELF;
		case PARENT_VALUE:
			return PARENT;
		case TOP_VALUE:
			return TOP;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private FrameTargetMember0(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} // FrameTargetMember0
