/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class RefactoringSessionTransformer {
    private Document fDocument = null;
    private final boolean fProjects;
    private Node fRefactoring = null;
    private List<Attr> fRefactoringArguments = null;
    private Node fSession = null;
    private List<Attr> fSessionArguments = null;

    public RefactoringSessionTransformer(boolean projects) {
        this.fProjects = projects;
    }

    private void addArguments(Node node, List<Attr> list) {
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            Collections.sort(list, new AttributeComparator());
            for (Attr attribute : list) {
                map.setNamedItem(attribute);
            }
        }
    }

    public void beginRefactoring(String id, long stamp, String project, String description, String comment, int flags) throws CoreException {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)description);
        Assert.isTrue((flags >= 0 ? 1 : 0) != 0);
        try {
            if (this.fDocument == null) {
                this.fDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
        }
        catch (FactoryConfigurationError | ParserConfigurationException exception) {
            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10006, exception.getLocalizedMessage(), null));
        }
        if (this.fRefactoring == null) {
            try {
                this.fRefactoringArguments = new ArrayList<Attr>(16);
                this.fRefactoring = this.fDocument.createElement("refactoring");
                Attr attribute = this.fDocument.createAttribute("id");
                attribute.setValue(id);
                this.fRefactoringArguments.add(attribute);
                if (stamp >= 0L) {
                    attribute = this.fDocument.createAttribute("stamp");
                    attribute.setValue(Long.valueOf(stamp).toString());
                    this.fRefactoringArguments.add(attribute);
                }
                if (flags != 0) {
                    attribute = this.fDocument.createAttribute("flags");
                    attribute.setValue(String.valueOf(flags));
                    this.fRefactoringArguments.add(attribute);
                }
                attribute = this.fDocument.createAttribute("description");
                attribute.setValue(description);
                this.fRefactoringArguments.add(attribute);
                if (comment != null && !"".equals(comment)) {
                    attribute = this.fDocument.createAttribute("comment");
                    attribute.setValue(comment);
                    this.fRefactoringArguments.add(attribute);
                }
                if (project != null && this.fProjects) {
                    attribute = this.fDocument.createAttribute("project");
                    attribute.setValue(project);
                    this.fRefactoringArguments.add(attribute);
                }
                if (this.fSession == null) {
                    this.fDocument.appendChild(this.fRefactoring);
                } else {
                    this.fSession.appendChild(this.fRefactoring);
                }
            }
            catch (DOMException exception) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10007, exception.getLocalizedMessage(), null));
            }
        }
    }

    public void beginSession(String comment, String version) throws CoreException {
        if (this.fDocument == null) {
            try {
                this.fDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                this.fSession = this.fDocument.createElement("session");
                this.fSessionArguments = new ArrayList<Attr>(2);
                Attr attribute = this.fDocument.createAttribute("version");
                attribute.setValue(version);
                this.fSessionArguments.add(attribute);
                if (comment != null && !"".equals(comment)) {
                    attribute = this.fDocument.createAttribute("comment");
                    attribute.setValue(comment);
                    this.fSessionArguments.add(attribute);
                }
                this.fDocument.appendChild(this.fSession);
            }
            catch (DOMException exception) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10007, exception.getLocalizedMessage(), null));
            }
            catch (ParserConfigurationException exception) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10006, exception.getLocalizedMessage(), null));
            }
        }
    }

    public void createArgument(String name, String value) throws CoreException {
        Assert.isNotNull((Object)name);
        Assert.isTrue((!"".equals(name) ? 1 : 0) != 0);
        Assert.isNotNull((Object)value);
        if (this.fDocument != null && this.fRefactoringArguments != null) {
            try {
                Attr attribute = this.fDocument.createAttribute(name);
                attribute.setValue(value);
                this.fRefactoringArguments.add(attribute);
            }
            catch (DOMException exception) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10007, exception.getLocalizedMessage(), null));
            }
        }
    }

    public void endRefactoring() {
        if (this.fRefactoring != null && this.fRefactoringArguments != null) {
            this.addArguments(this.fRefactoring, this.fRefactoringArguments);
        }
        this.fRefactoringArguments = null;
        this.fRefactoring = null;
    }

    public void endSession() {
        if (this.fSession != null && this.fSessionArguments != null) {
            this.addArguments(this.fSession, this.fSessionArguments);
        }
        this.fSessionArguments = null;
        this.fSession = null;
    }

    public Document getResult() {
        Document document = this.fDocument;
        this.fDocument = null;
        return document;
    }

    private static final class AttributeComparator
    implements Comparator<Attr> {
        private AttributeComparator() {
        }

        @Override
        public int compare(Attr o1, Attr o2) {
            return Collator.getInstance().compare(o1.getName(), o2.getName());
        }
    }
}

