/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.client;

import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.data.IdeClientSession;
import org.eclipse.osee.framework.core.exception.OseeAuthenticationRequiredException;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.osgi.service.event.Event;

public class TopicEventUtil {
    public static final String SENDER_SESSION_PROPERTY = "senderSession";

    public static String getSessionJson() {
        String sessionJson = JsonUtil.toJson((Object)ClientSessionManager.getSession());
        return sessionJson;
    }

    public static IdeClientSession getSessionJson(String sessionJson) {
        try {
            IdeClientSession oseeSession = (IdeClientSession)JsonUtil.readValue((String)sessionJson, IdeClientSession.class);
            return oseeSession;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Boolean isRemoteOrNull(Event event) {
        IdeClientSession oseeSession;
        Boolean isRemote = null;
        String sessionJson = (String)event.getProperty(SENDER_SESSION_PROPERTY);
        if (Strings.isValid((String)sessionJson) && (oseeSession = TopicEventUtil.getSessionJson(sessionJson)) != null) {
            isRemote = TopicEventUtil.isRemote(oseeSession);
        }
        return isRemote;
    }

    public static boolean isRemote(IdeClientSession oseeSession) {
        try {
            String sessionId = oseeSession.getId();
            if (!"Invalid".equalsIgnoreCase(sessionId)) {
                IdeClientSession session = ClientSessionManager.getSession();
                return !sessionId.equals(session.getId());
            }
            return false;
        }
        catch (OseeAuthenticationRequiredException oseeAuthenticationRequiredException) {
            return false;
        }
    }
}

